package com.liquidnet.service.goblin.param;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 合集
 * </p>
 *
 * @author liquidnet
 * @since 2022-01-06
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinFrontCompilationsParam implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 合集id
     */
    @ApiModelProperty(value = "合集id")
    private String compilationsId;

    /**
     * 合集名称
     */
    @ApiModelProperty(value = "合集名称")
    private String name;

    /**
     * spu ids
     */
    @ApiModelProperty(value = "spu ids")
    private String spuIds;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime createTime;

    /**
     * 修改时间
     */
    @ApiModelProperty(value = "修改时间")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern=DateUtil.DATE_FULL_STR)
    private LocalDateTime updateTime;

    /**
     * 0未删除1已删除
     */
    @ApiModelProperty(value = "0未删除1已删除")
    private Integer delTag;


}
