package com.liquidnet.service.executor.main.handler;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.feign.kylin.task.FeignPlatformAlipayBackClient;
import com.liquidnet.service.feign.platform.task.FeignPlatformCandyTaskClient;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.annotation.XxlJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * Platform
 */
@Component
public class PlatformTaskHandler {
    private static final Logger log = LoggerFactory.getLogger(PlatformTaskHandler.class);

    @Autowired
    private FeignPlatformAlipayBackClient feignPlatformAlipayBackClient;
    @Autowired
    private FeignPlatformCandyTaskClient feignPlatformCandyTaskClient;

    @XxlJob(value = "sev-platform:alipayActiveCallbackHandler")
    public ReturnT<String> alipayActiveCallbackHandler() {
        try {
            String result = feignPlatformAlipayBackClient.alipayActiveCallback().getData();
            log.info("alipayActiveCallback：结果："+result);
            return ReturnT.SUCCESS;
        } catch (Exception e) {
            return ReturnT.FAIL;
        }
    }

    @XxlJob(value = "sev-platform:candyCouponIssuanceHandler")
    public ReturnT<String> candyCouponIssuanceHandler() {
        try {
            ResponseDto<String> dto = feignPlatformCandyTaskClient.issueCoupons();
            log.info("result of handler:{}", dto.toJson());
            return ReturnT.SUCCESS;
        } catch (Exception e) {
            log.error("exception of handler:{}", e.getMessage(), e);
            return ReturnT.FAIL;
        }
    }
}
