package com.liquidnet.service.kylin.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.liquidnet.common.mq.constant.MQConst;
import com.liquidnet.commons.lang.util.*;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.kylin.constant.KylinTableStatusConst;
import com.liquidnet.service.kylin.dto.param.RefundCallbackParam;
import com.liquidnet.service.kylin.dto.vo.mongo.*;
import com.liquidnet.service.kylin.entity.*;
import com.liquidnet.service.kylin.mapper.*;
import com.liquidnet.service.kylin.utils.DataUtils;
import com.liquidnet.service.kylin.utils.MongoVoUtils;
import com.mongodb.BasicDBObject;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.client.result.UpdateResult;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 订单退款表 服务实现类 处理数据 退款后状态的变化
 * </p>
 *
 * @author jiaangxiulong
 * @since 2021-05-26
 */
@Slf4j
@Service
public class KylinRefundsStatusServiceImpl {

    @Autowired
    private KylinOrderTicketsMapper kylinOrderTicketsMapper;

    @Autowired
    private KylinOrderTicketStatusMapper kylinOrderTicketStatusMapper;

    @Autowired
    private KylinOrderRefundsMapper kylinOrderRefundsMapper;

    @Autowired
    private KylinOrderTicketEntitiesMapper kylinOrderTicketEntitiesMapper;

    @Autowired
    private KylinOrderRefundsEntitiesMapper kylinOrderRefundsEntitiesMapper;

    @Autowired
    private KylinOrderTicketRelationsMapper kylinOrderTicketRelationsMapper;

    @Autowired
    MongoTemplate mongoTemplate;

    @Autowired
    private MongoConverter mongoConverter;

    @Autowired
    private DataUtils dataUtils;

    @Autowired
    private MongoVoUtils mongoVoUtils;
    @Autowired
    private RabbitTemplate rabbitTemplate;

    public boolean orderTicketRefunded(RefundCallbackParam refundCallbackParam, KylinOrderRefunds refundInfo) {
        List<KylinOrderRefundEntities> refundEntities = kylinOrderRefundsEntitiesMapper.selectList(
                new QueryWrapper<KylinOrderRefundEntities>().eq("order_refunds_id", refundInfo.getOrderRefundsId())
        );
        List<String> orderTicketEntitiesIdsArr = refundEntities.stream().map(KylinOrderTicketEntities -> KylinOrderTicketEntities.getOrderTicketEntitiesId()).collect(Collectors.toList());
        String orderTicketsId = refundInfo.getOrderTicketsId();

        KylinOrderTicketRelations orderRelations = kylinOrderTicketRelationsMapper.selectOne(
                new QueryWrapper<KylinOrderTicketRelations>().eq("order_id", orderTicketsId)
        );

        // 更新数据
        // 订单状态表
        KylinOrderTickets orderInfo = kylinOrderTicketsMapper.selectOne(
                new QueryWrapper<KylinOrderTickets>().eq("order_tickets_id", orderTicketsId)
        );
        KylinOrderTicketStatus orderStatusTable = new KylinOrderTicketStatus();
        int newStatus = 0;
        if (refundCallbackParam.getRefund_price() + orderInfo.getPriceRefund().doubleValue() == orderInfo.getPriceActual().doubleValue()) {
            newStatus = KylinTableStatusConst.ORDER_STATUS4;
        } else {
            newStatus = KylinTableStatusConst.ORDER_STATUS6;
        }
        orderStatusTable.setStatus(newStatus);
        orderStatusTable.setUpdatedAt(LocalDateTime.now());
        kylinOrderTicketStatusMapper.update(
                orderStatusTable, new UpdateWrapper<KylinOrderTicketStatus>()
                        .eq("order_id", orderTicketsId)
        );

        // 入场人
        double priceActual = orderInfo.getPriceActual().doubleValue();
        double priceExpress = orderInfo.getPriceExpress().doubleValue();
        int allEntitiesCount = kylinOrderTicketEntitiesMapper.selectCount(// 总入场人数量 排出未付款的 用来计算单入场人的价格
                new QueryWrapper<KylinOrderTicketEntities>()
                        .eq("order_id", orderTicketsId)
                        .ne("is_payment", KylinTableStatusConst.ENTITIES_IS_PAYMENT0)
        );
        double onePrice = (priceActual - priceExpress) / allEntitiesCount;//单价
        int refundNumber = 0;
        for (String entitiesId : orderTicketEntitiesIdsArr) {
            KylinOrderTicketEntities EntitiesInfo = kylinOrderTicketEntitiesMapper.selectOne(//已退完成的
                    new QueryWrapper<KylinOrderTicketEntities>()
                            .eq("order_ticket_entities_id", entitiesId)
            );
            BigDecimal refundedPrice = EntitiesInfo.getRefundPrice();

            KylinOrderRefundEntities refundEntitiesInfo = kylinOrderRefundsEntitiesMapper.selectOne(
                    new QueryWrapper<KylinOrderRefundEntities>()
                            .eq("order_refunds_id", refundInfo.getOrderRefundsId())
                            .eq("order_ticket_entities_id", entitiesId)
            );

            KylinOrderTicketEntities entitiesTable = new KylinOrderTicketEntities();
            double priceNew = refundEntitiesInfo.getRefundPrice().doubleValue() + refundedPrice.doubleValue();
            int isPayment = 0;
            if (priceNew == onePrice) {
                isPayment = KylinTableStatusConst.ENTITIES_IS_PAYMENT3;
                refundNumber++;
            } else {
                isPayment = KylinTableStatusConst.ENTITIES_IS_PAYMENT4;
            }
            entitiesTable.setIsPayment(isPayment);
            entitiesTable.setUpdatedAt(LocalDateTime.now());
            entitiesTable.setRefundPrice(BigDecimal.valueOf(priceNew));
            Integer[] entitiesTableIsPayment = {KylinTableStatusConst.ENTITIES_IS_PAYMENT2, KylinTableStatusConst.ENTITIES_IS_PAYMENT4};
            kylinOrderTicketEntitiesMapper.update(entitiesTable, new UpdateWrapper<KylinOrderTicketEntities>()
                    .eq("order_ticket_entities_id", entitiesId)
                    .in("is_payment", entitiesTableIsPayment)
            );

            HashMap<String, Object> EntitiesVo = new HashMap<>();
            EntitiesVo.put("updatedAt", DateUtil.getNowTime());
            EntitiesVo.put("refundPrice", BigDecimal.valueOf(priceNew));
            EntitiesVo.put("isPayment", isPayment);
            BasicDBObject EntitiesVov = new BasicDBObject("$set", mongoConverter.convertToMongoType(EntitiesVo));
            UpdateResult updateResult = mongoTemplate.getCollection(KylinOrderTicketEntitiesVo.class.getSimpleName()).updateOne(
                    Query.query(Criteria.where("orderTicketEntitiesId").is(entitiesId)).getQueryObject(),
                    EntitiesVov
            );

            dataUtils.delOrderTicketEntitiesRedis(entitiesId);
        }

        // 订单表
        double price = orderInfo.getPriceRefund().doubleValue() + refundCallbackParam.getRefund_price();
        Integer num = orderInfo.getRefundNumber() + refundNumber;
        KylinOrderTickets update = new KylinOrderTickets();
        update.setRefundNumber(num);
        update.setPriceRefund(BigDecimal.valueOf(price));
        update.setUpdatedAt(LocalDateTime.now());
        kylinOrderTicketsMapper.update(
                update, new UpdateWrapper<KylinOrderTickets>()
                        .eq("order_tickets_id", orderTicketsId)
        );

        HashMap<String, Object> orderVo = new HashMap<>();
        orderVo.put("updatedAt", DateUtil.getNowTime());
        orderVo.put("priceRefund", BigDecimal.valueOf(price));
        orderVo.put("status", newStatus);
        orderVo.put("refundNumber", num);
        BasicDBObject orderVov = new BasicDBObject("$set", mongoConverter.convertToMongoType(orderVo));
        UpdateResult orderUpdateResult = mongoTemplate.getCollection(KylinOrderTicketVo.class.getSimpleName()).updateOne(
                Query.query(Criteria.where("orderTicketsId").is(orderTicketsId)).getQueryObject(),
                orderVov
        );
        dataUtils.delOrderTicketRedis(orderTicketsId);
        mongoVoUtils.resetOrderListVo(orderInfo.getUserId(), 2, orderTicketsId, null);

        // 退款单完成
        KylinOrderRefunds kylinOrderRefunds = new KylinOrderRefunds();
        kylinOrderRefunds.setStatus(KylinTableStatusConst.ORDER_REFUND_STATUS_REFUNDED);
        kylinOrderRefunds.setRefundCode(refundCallbackParam.getRefund_code());
        kylinOrderRefunds.setRefundType(refundCallbackParam.getRefund_type());
        kylinOrderRefunds.setRefundId(refundCallbackParam.getRefund_id());
        kylinOrderRefunds.setRefundAt(refundCallbackParam.getRefund_at());
        kylinOrderRefunds.setUpdatedAt(LocalDateTime.now());
        kylinOrderRefundsMapper.update(
                kylinOrderRefunds,
                new UpdateWrapper<KylinOrderRefunds>().in("order_refunds_id", refundInfo.getOrderRefundsId())
        );

        log.info("Info:RefundController refundCallback: 开始处理库存");
        if (refundInfo.getType() == KylinTableStatusConst.ORDER_REFUND_TYPE_APPLY) {
            log.info("Info:RefundController refundCallback: 开始处理库存 1");
            // 退还库存
            for (String entitiesId : orderTicketEntitiesIdsArr) {
                log.info("Info:RefundController refundCallback: entitiesId{}", entitiesId);
                KylinOrderTicketEntities entitiesInfo = kylinOrderTicketEntitiesMapper.selectOne(
                        new QueryWrapper<KylinOrderTicketEntities>().eq("order_ticket_entities_id", entitiesId)
                );
                log.info("Info:RefundController refundCallback: IsPayment{}", entitiesInfo.getIsPayment());
                if (entitiesInfo.getIsPayment() == KylinTableStatusConst.ENTITIES_IS_PAYMENT3) {
                    dataUtils.changeSurplusGeneral(entitiesInfo.getTicketId(), 1);
                    log.info("Info:RefundController refundCallback: UserId{}-PerformanceId{}-TicketId{}", orderInfo.getUserId(), orderRelations.getPerformanceId(), entitiesInfo.getTicketId());
                    dataUtils.changeBuyInfo(orderInfo.getUserId(), "", orderRelations.getPerformanceId(), entitiesInfo.getTicketId(), -1);
                }
            }
        }

        return true;
    }

    public Boolean orderTicketRefunding(
            KylinOrderTickets orderInfo, String orderTicketsId,
            double RefundPriceExpress,
            List<String> ticketEntityIds, List<Double> entitiesPrice
    ) {
        if (CollectionUtil.isEmpty(ticketEntityIds)) {
            return false;
        }
        // 基础数据
        String authId = "";
        String authName = "system_overtime_order_refund";
        String reason = "订单支付超时自动退款";
        // 本次退款票总金额
        double entitiesPriceSum = entitiesPrice.stream().mapToDouble(Double::doubleValue).sum();

        // TODO: 2021/5/27 事物 and 部分退款
        // 更新数据
        // 订单状态表 和 缓存
        KylinOrderTicketStatus orderStatusTable = new KylinOrderTicketStatus();
        orderStatusTable.setStatus(KylinTableStatusConst.ORDER_STATUS3);
        kylinOrderTicketStatusMapper.update(orderStatusTable, new UpdateWrapper<KylinOrderTicketStatus>()
                .eq("order_id", orderTicketsId));

        KylinOrderTicketVo kylinOrderTicketVo = new KylinOrderTicketVo();
        kylinOrderTicketVo.setStatus(KylinTableStatusConst.ORDER_STATUS3);
        BasicDBObject orderObject = new BasicDBObject("$set", JSON.parse(JsonUtils.toJson(kylinOrderTicketVo)));
        Document orderDoc = mongoTemplate.getCollection(KylinOrderTicketVo.class.getSimpleName()).findOneAndUpdate(
                Query.query(Criteria.where("orderTicketsId").is(orderTicketsId)).getQueryObject(),
                orderObject,
                new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER)
        );
        dataUtils.delOrderTicketRedis(orderTicketsId);
        mongoVoUtils.resetOrderListVo(orderInfo.getUserId(), 2, orderTicketsId, null);


        // 订单入场人表 和 缓存
        for (String v : ticketEntityIds) {
            KylinOrderTicketEntities entitiesTable = new KylinOrderTicketEntities();
            entitiesTable.setIsPayment(KylinTableStatusConst.ENTITIES_IS_PAYMENT2);
            kylinOrderTicketEntitiesMapper.update(entitiesTable, new UpdateWrapper<KylinOrderTicketEntities>()
                    .eq("order_ticket_entities_id", v));

            KylinOrderTicketEntitiesVo kylinOrderTicketEntitiesVo = new KylinOrderTicketEntitiesVo();
            kylinOrderTicketEntitiesVo.setIsPayment(KylinTableStatusConst.ENTITIES_IS_PAYMENT2);
            BasicDBObject entitiesObject = new BasicDBObject("$set", JSON.parse(JsonUtils.toJson(kylinOrderTicketEntitiesVo)));
            Document entitiesDoc = mongoTemplate.getCollection(KylinOrderTicketEntitiesVo.class.getSimpleName()).findOneAndUpdate(
                    Query.query(Criteria.where("orderTicketEntitiesId").is(v)).getQueryObject(),
                    entitiesObject,
                    new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER)
            );

            dataUtils.delOrderTicketEntitiesRedis(v);
        }

        // 退款明细
        KylinOrderRefunds kylinOrderRefunds = new KylinOrderRefunds();
        String orderRefundsId = IDGenerator.nextSnowId();
        kylinOrderRefunds.setOrderRefundsId(orderRefundsId);
        kylinOrderRefunds.setOrderTicketsId(orderTicketsId);

        Integer refundCount = kylinOrderRefundsMapper.selectCount(
                new QueryWrapper<KylinOrderRefunds>()
                        .eq("order_tickets_id", orderTicketsId)
        );

        String orderRefundCode = orderInfo.getOrderCode();
        String codeNum = StringUtils.leftPad(String.valueOf(refundCount), 3, "0");
        kylinOrderRefunds.setOrderRefundCode(orderRefundCode.concat(codeNum));
        kylinOrderRefunds.setPrice(BigDecimal.valueOf(entitiesPriceSum));
        kylinOrderRefunds.setPriceExpress(BigDecimal.valueOf(RefundPriceExpress));
        kylinOrderRefunds.setStatus(KylinTableStatusConst.ORDER_REFUND_STATUS_APPLY);

        kylinOrderRefunds.setType(KylinTableStatusConst.ORDER_REFUND_TYPE_APPLY);
        kylinOrderRefunds.setApplicantId(authId);
        kylinOrderRefunds.setApplicantName(authName);
        kylinOrderRefunds.setApplicantAt(LocalDateTime.now());
        kylinOrderRefunds.setType(1);
        kylinOrderRefunds.setReason(reason);
        if (RefundPriceExpress > 0 && entitiesPriceSum > 0) {
            kylinOrderRefunds.setRefundCate(KylinTableStatusConst.ORDER_REFUND_CATE3);
        } else if (RefundPriceExpress > 0) {
            kylinOrderRefunds.setRefundCate(KylinTableStatusConst.ORDER_REFUND_CATE2);
        } else if (entitiesPriceSum > 0) {
            kylinOrderRefunds.setRefundCate(KylinTableStatusConst.ORDER_REFUND_CATE1);
        }
        kylinOrderRefunds.setCreatedAt(LocalDateTime.now());
        int rows = kylinOrderRefundsMapper.insert(kylinOrderRefunds);

        // 退款入场人表
        KylinOrderRefundEntities kylinOrderRefundEntities = new KylinOrderRefundEntities();
        for (int i = 0; i <= ticketEntityIds.size() - 1; i++) {
            String orderRefundsEntitiesId = IDGenerator.nextSnowId();
            kylinOrderRefundEntities.setOrderRefundsEntitiesId(orderRefundsEntitiesId);
            kylinOrderRefundEntities.setOrderRefundsId(orderRefundsId);
            kylinOrderRefundEntities.setRefundPrice(BigDecimal.valueOf(entitiesPrice.get(i)));
            kylinOrderRefundEntities.setOrderTicketEntitiesId(ticketEntityIds.get(i));
            kylinOrderRefundEntities.setCreatedAt(LocalDateTime.now());
            int rowsR = kylinOrderRefundsEntitiesMapper.insert(kylinOrderRefundEntities);
        }

        return true;
    }


    public Boolean userOrderTicketRefunding(
            KylinOrderTicketVo orderInfo,
            double refundPrice,
            String orderEntitiesId,
            String reason,
            String picList,
            String uid,
            String username,
            int refundCount
    ) {
        try {
            LocalDateTime time = LocalDateTime.now();
            String strTime = DateUtil.Formatter.yyyyMMddHHmmss.format(time);
            // 订单状态表 和 缓存
            KylinOrderTicketStatus orderStatusTable = new KylinOrderTicketStatus();
            orderStatusTable.setStatus(KylinTableStatusConst.ORDER_STATUS3);
            orderStatusTable.setUpdatedAt(time);


            KylinOrderTicketVo kylinOrderTicketVo = new KylinOrderTicketVo();
            kylinOrderTicketVo.setStatus(KylinTableStatusConst.ORDER_STATUS3);
            kylinOrderTicketVo.setUpdatedAt(DateUtil.Formatter.yyyyMMddHHmmss.format(time));
            BasicDBObject orderObject = new BasicDBObject("$set", JSON.parse(JsonUtils.toJson(kylinOrderTicketVo)));
            mongoTemplate.getCollection(KylinOrderTicketVo.class.getSimpleName()).updateOne(
                    Query.query(Criteria.where("orderTicketsId").is(orderInfo.getOrderTicketsId())).getQueryObject(),
                    orderObject
            );
            dataUtils.delOrderTicketRedis(orderInfo.getOrderTicketsId());
            mongoVoUtils.resetOrderListVo(orderInfo.getUserId(), 2, orderInfo.getOrderTicketsId(), null);


            // 订单入场人表 和 缓存
            KylinOrderTicketEntities entitiesTable = new KylinOrderTicketEntities();
            entitiesTable.setIsPayment(KylinTableStatusConst.ENTITIES_IS_PAYMENT2);
            entitiesTable.setUpdatedAt(time);


            KylinOrderTicketEntitiesVo kylinOrderTicketEntitiesVo = new KylinOrderTicketEntitiesVo();
            kylinOrderTicketEntitiesVo.setIsPayment(KylinTableStatusConst.ENTITIES_IS_PAYMENT2);
            kylinOrderTicketEntitiesVo.setUpdatedAt(strTime);
            BasicDBObject entitiesObject = new BasicDBObject("$set", JSON.parse(JsonUtils.toJson(kylinOrderTicketEntitiesVo)));
            mongoTemplate.getCollection(KylinOrderTicketEntitiesVo.class.getSimpleName()).updateOne(
                    Query.query(Criteria.where("orderTicketEntitiesId").is(orderEntitiesId)).getQueryObject(),
                    entitiesObject
            );
            dataUtils.delOrderTicketEntitiesRedis(orderEntitiesId);

            // 退款明细
            KylinOrderRefunds kylinOrderRefunds = new KylinOrderRefunds();
            String orderRefundsId = IDGenerator.nextSnowId();
            kylinOrderRefunds.setOrderRefundsId(orderRefundsId);
            kylinOrderRefunds.setOrderTicketsId(orderInfo.getOrderTicketsId());
            String orderRefundCode = orderInfo.getOrderCode();
            String codeNum = StringUtils.leftPad(String.valueOf(refundCount), 3, "0");
            kylinOrderRefunds.setOrderRefundCode(orderRefundCode.concat(codeNum));
            kylinOrderRefunds.setPrice(BigDecimal.valueOf(refundPrice));
            kylinOrderRefunds.setPriceExpress(orderInfo.getPriceExpress());
            kylinOrderRefunds.setStatus(KylinTableStatusConst.ORDER_REFUND_STATUS_APPLY);
            kylinOrderRefunds.setType(KylinTableStatusConst.ORDER_REFUND_TYPE_APPLY);
            kylinOrderRefunds.setApplicantId(uid);
            kylinOrderRefunds.setApplicantName(username);
            kylinOrderRefunds.setApplicantAt(time);
            kylinOrderRefunds.setReason(reason);
            if (orderInfo.getPriceExpress().doubleValue() > 0 && refundPrice > 0) {
                kylinOrderRefunds.setRefundCate(KylinTableStatusConst.ORDER_REFUND_CATE3);
            } else if (orderInfo.getPriceExpress().doubleValue() > 0) {
                kylinOrderRefunds.setRefundCate(KylinTableStatusConst.ORDER_REFUND_CATE2);
            } else if (refundPrice > 0) {
                kylinOrderRefunds.setRefundCate(KylinTableStatusConst.ORDER_REFUND_CATE1);
            }
            kylinOrderRefunds.setCreatedAt(time);

            KylinOrderRefundsVoBase orderRefundsVo = new KylinOrderRefundsVoBase();
            BeanUtils.copyProperties(kylinOrderRefunds,orderRefundsVo);
            orderRefundsVo.setCreatedAt(strTime);
            orderRefundsVo.setApplicantAt(strTime);
            mongoTemplate.insert(orderRefundsVo, KylinOrderRefundsVoBase.class.getSimpleName());


            // 退款入场人表
            KylinOrderRefundEntities kylinOrderRefundEntities = new KylinOrderRefundEntities();
            String orderRefundsEntitiesId = IDGenerator.nextSnowId();
            kylinOrderRefundEntities.setOrderRefundsEntitiesId(orderRefundsEntitiesId);
            kylinOrderRefundEntities.setOrderRefundsId(orderRefundsId);
            kylinOrderRefundEntities.setRefundPrice(BigDecimal.valueOf(refundPrice));
            kylinOrderRefundEntities.setOrderTicketEntitiesId(orderEntitiesId);
            kylinOrderRefundEntities.setCreatedAt(time);

            KylinOrderRefundEntitiesVo orderRefundEntitiesVo = new KylinOrderRefundEntitiesVo();
            BeanUtils.copyProperties(orderRefundEntitiesVo,kylinOrderRefundEntities);
            orderRefundEntitiesVo.setCreatedAt(strTime);
            mongoTemplate.insert(orderRefundEntitiesVo,KylinOrderRefundEntitiesVo.class.getSimpleName());

            //退款图片
            KylinOrderRefundPic orderRefundPic = new KylinOrderRefundPic();
            orderRefundPic.setOrderRefundsId(IDGenerator.nextSnowId());
            orderRefundPic.setOrderRefundsId(kylinOrderRefunds.getOrderRefundsId());
            orderRefundPic.setPicUrl(picList);
            orderRefundPic.setCreatedAt(time);

            KylinOrderRefundPicVo orderRefundPicVo = new KylinOrderRefundPicVo();
            BeanUtils.copyProperties(orderRefundPicVo,orderRefundPic);
            orderRefundPicVo.setCreatedAt(strTime);
            mongoTemplate.insert(orderRefundPicVo,KylinOrderRefundPicVo.class.getSimpleName());

            //MQ
            LinkedList<String> sqls = new LinkedList<>();
            LinkedList<Object[]> sqlsDataA = new LinkedList<>();
            LinkedList<Object[]> sqlsDataB = new LinkedList<>();
            LinkedList<Object[]> sqlsDataC = new LinkedList<>();
            LinkedList<Object[]> sqlsDataD = new LinkedList<>();
            LinkedList<Object[]> sqlsDataE = new LinkedList<>();

            sqls.add(SqlMapping.get("kylin_order_ticket_status.refund"));
            sqls.add(SqlMapping.get("kylin_order_ticket_entities.refund"));
            sqls.add(SqlMapping.get("kylin_order_refund.refund"));
            sqls.add(SqlMapping.get("kylin_order_refund_entities.refund"));
            sqls.add(SqlMapping.get("kylin_order_refund_pic.refund"));

            sqlsDataA.add(new Object[]{
                    orderStatusTable.getStatus(), orderStatusTable.getUpdatedAt(), orderInfo.getOrderTicketsId(), orderInfo.getChangeDate(), orderInfo.getChangeDate()
            });
            sqlsDataB.add(new Object[]{
                    entitiesTable.getIsPayment(), entitiesTable.getUpdatedAt(), orderEntitiesId, orderInfo.getChangeDate(), orderInfo.getChangeDate()
            });
            sqlsDataC.add(new Object[]{
                    kylinOrderRefunds.getOrderRefundsId(), kylinOrderRefunds.getOrderTicketsId(), kylinOrderRefunds.getOrderRefundCode(),
                    kylinOrderRefunds.getPrice(), kylinOrderRefunds.getPriceExpress(), kylinOrderRefunds.getStatus(),
                    kylinOrderRefunds.getType(), kylinOrderRefunds.getApplicantId(), kylinOrderRefunds.getApplicantName(),
                    kylinOrderRefunds.getApplicantAt(), kylinOrderRefunds.getReason(),
                    kylinOrderRefunds.getRefundCate(), kylinOrderRefunds.getCreatedAt()
            });
            sqlsDataD.add(new Object[]{
                    kylinOrderRefundEntities.getOrderRefundsEntitiesId(), kylinOrderRefundEntities.getOrderRefundsId(), kylinOrderRefundEntities.getRefundPrice(),
                    kylinOrderRefundEntities.getOrderTicketEntitiesId(), kylinOrderRefundEntities.getCreatedAt()
            });
            sqlsDataE.add(new Object[]{
                    orderRefundPic.getOrderRefundsId(), orderRefundPic.getOrderRefundsId(), orderRefundPic.getPicUrl(), orderRefundPic.getCreatedAt()
            });

            rabbitTemplate.convertAndSend(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_PAY, MQConst.ROUTING_KEY_SQL_ORDER_PAY,
                    SqlMapping.gets(sqls, sqlsDataA, sqlsDataB, sqlsDataC, sqlsDataD, sqlsDataE));

            return true;
        }catch (Exception e){
            e.printStackTrace();
            return false;
        }
    }
}
