package com.liquidnet.service.order.controller;

import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.codec.vo.EncryptedReq;
import com.liquidnet.service.goblin.dto.manage.GoblinOrderParam;
import com.liquidnet.service.goblin.dto.vo.GoblinPayInnerResultVo;
import com.liquidnet.service.goblin.param.PayAgainParam;
import com.liquidnet.service.goblin.param.RefundCallbackParam;
import com.liquidnet.service.goblin.param.SyncOrderParam;
import com.liquidnet.service.goblin.service.IGoblinOrderService;
import io.swagger.annotations.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;

@Slf4j
@Api(tags = "商城-支付相关")
@RestController
@RequestMapping("/goblin")
public class GoblinOrderController {

    @Autowired
    IGoblinOrderService goblinAppOrderService;

    @PostMapping("pre")
    @ApiOperation("下单")
    public ResponseDto<GoblinPayInnerResultVo> checkOrder(@RequestBody EncryptedReq<GoblinOrderParam> param) {
        GoblinOrderParam payOrderParam = param.getData();
        String uid = CurrentUtil.getCurrentUid();
        return goblinAppOrderService.checkOrder(payOrderParam,uid);
    }

    @PostMapping("fc7bce6d6c2213b866f76493f92224b7")
    @ApiOperation("fc7bce6d6c2213b866f76493f92224b7")
    public ResponseDto<GoblinPayInnerResultVo> checkOrder(@RequestBody GoblinOrderParam param) {
        String uid = CurrentUtil.getCurrentUid();
        return goblinAppOrderService.checkOrder(param,uid);
    }

    @PostMapping("syncOrder")
    @ApiOperation("支付回调")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public String syncOrder(@ModelAttribute @Valid SyncOrderParam syncOrderParam) {
        return goblinAppOrderService.syncOrder(syncOrderParam);
    }

    @ApiOperation(value = "退款回调")
    @PostMapping(value = "refundSyncOrder")
    public String refundSyncOrder(RefundCallbackParam refundCallbackParam) {
        return goblinAppOrderService.refundSyncOrder(refundCallbackParam);
    }

    @PostMapping("paySuccess")
    @ApiOperation("汇付支付成功回调")
    @ResponseBody
    public String refundDetails(HttpServletRequest request) {
        return goblinAppOrderService.huiFuSync(request);
    }

    @PostMapping("payAgain")
    @ApiOperation("再次支付")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<GoblinPayInnerResultVo> payAgain(@RequestBody @Valid PayAgainParam param) {
        return goblinAppOrderService.payAgain(param);
    }

    @PostMapping("checkPayment")
    @ApiOperation("订单状态")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "orderId", value = "订单id", example = "1"),
    })
    public ResponseDto<Integer> checkOrderResult(@RequestParam("orderId") @Valid String orderId) {
        return goblinAppOrderService.checkOrderResult(orderId);
    }

    @PostMapping("checkPaymentMaster")
    @ApiOperation("订单状态[主订单号]")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "masterCode", value = "masterCode", example = "1"),
    })
    public ResponseDto<Integer> checkOrderResultMasterCode(@RequestParam("masterCode") @Valid String masterCode) {
        return goblinAppOrderService.checkOrderResultMaterCode(masterCode);
    }


    @PostMapping("zhengzai/fc7bce6d6c2213b866f76493f92224b7")
    @ApiOperation("正在下单-下单")
    public ResponseDto<GoblinPayInnerResultVo> checkOrderZhengzai(@RequestBody GoblinOrderParam param) {
        if (param.getUid() == null) {
            param.setUid("zhengzai");
        }
        return goblinAppOrderService.checkOrder(param, param.getUid());
    }

//    @PostMapping("zhengzai/checkPayment")
//    @ApiOperation("订单状态")
//    @ApiResponse(code = 200, message = "接口返回对象参数")
//    @ApiImplicitParams({
//            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "masterCode", value = "masterCode", example = "1"),
//    })
//    public ResponseDto<Integer> checkOrderResultMasterCodeZhengzai(@RequestParam("masterCode") @Valid String masterCode) {
//        return goblinAppOrderService.checkOrderResultMaterCode(masterCode);
//    }

}
