package com.liquidnet.service.consumer.dragon.config;

import com.liquidnet.common.cache.redis.config.RedisStreamConfig;
import com.liquidnet.service.consumer.dragon.receiver.RedisMchNotifyReceiver;
import com.liquidnet.service.dragon.constant.DragonConstant;
import lombok.var;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.stream.StreamMessageListenerContainer;
import org.springframework.data.redis.stream.Subscription;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: ConsumerPayRedisStreamConfig
 * @Package com.liquidnet.service.consumer.dragon.config
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/11 14:45
 */
@Configuration
public class ConsumerMchNotifyRedisStreamConfig extends RedisStreamConfig {
    @Autowired
    private RedisMchNotifyReceiver redisMchNotifyReceiver;

    private Subscription buildReceiverSubscription(StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer, int t) {
        return listenerContainer.receiveAutoAck(Consumer.from(DragonConstant.MysqlRedisQueueEnum.PAY_MCH_NOTIFY_GROUP.getCode(), getConsumerName(DragonConstant.MysqlRedisQueueEnum.PAY_MCH_NOTIFY_KEY.name() + t)),
                StreamOffset.create(DragonConstant.MysqlRedisQueueEnum.PAY_MCH_NOTIFY_KEY.getCode(), ReadOffset.lastConsumed()), redisMchNotifyReceiver);
    }

    @Bean
    public Subscription subscriptionMchNotify01(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = buildReceiverSubscription(listenerContainer, 1);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionMchNotify02(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = buildReceiverSubscription(listenerContainer, 2);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionMchNotify03(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = buildReceiverSubscription(listenerContainer, 3);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionMchNotify04(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = buildReceiverSubscription(listenerContainer, 4);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionMchNotify05(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = buildReceiverSubscription(listenerContainer, 5);
        listenerContainer.start();
        return subscription;
    }
}
