package com.liquidnet.service.sweet.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

@ApiModel(value = "SweetDouDouParam", description = "入参")
@Data
public class SweetDouDouParam implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(position = 10, required = true, value = "观演人姓名", example = "张三")
    @NotBlank(message = "username不能为空")
    private String username;

    @ApiModelProperty(position = 11, required = true, value = "观演人手机号", example = "15811112222")
    @NotBlank(message = "phone不能为空")
    private String phone;

    @ApiModelProperty(position = 12, required = true, value = "购买平台", example = "大麦")
    @NotBlank(message = "platform不能为空")
    private String platform;

    @ApiModelProperty(position = 13, required = true, value = "购买订单号", example = "23424353477473")
    @NotBlank(message = "orderCodee不能为空")
    private String orderCode;

    @ApiModelProperty(position = 14, required = true, value = "想给doudou说的话", example = "我爱你啦啦啦")
    private String mark;

}
