package com.liquidnet.service.kylin.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 批量退款表
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-25
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class KylinOrderRefundBatches implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Integer mid;

    /**
     * refund_batch_id
     */
    private String refundBatchId;

    /**
     * 目标id target_type=1为演出id
     */
    private String targetId;

    /**
     * 批量退款状态 1申请退款 2取消退款 3运营驳回审核 4运营通过审核 5财务驳回审核 6财务通过审核
     */
    private Integer status;

    /**
     * 批量执行时间
     */
    private LocalDateTime executorAt;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;


}
