package com.liquidnet.service.galaxy.dto.param;

import com.liquidnet.commons.lang.util.JsonUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyQueryUserSeriesNftListReqDto
 * @Package com.liquidnet.service.galaxy.dto.param
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/4/7 16:27
 */
@ApiModel(value = "GalaxyQueryUserSeriesNftListReqDto", description = "用户系列NFT查询")
@Data
public class GalaxyQueryUserSeriesNftListReqDto extends GalaxyBaseReqDto implements Serializable,Cloneable{
    @ApiModelProperty(position = 1, required = true, value = "用户ID[30]")
    @NotBlank(message = "用户ID不能为空！")
    @Size(min = 1, max = 30, message = "用户ID限制2-30位且不能包含特殊字符")
    private String userId;

    @ApiModelProperty(position = 1, required = true, value = "skuId")
    private String skuId;

    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }

    private static final GalaxyQueryUserSeriesNftListReqDto obj = new GalaxyQueryUserSeriesNftListReqDto();

    public static GalaxyQueryUserSeriesNftListReqDto getNew() {
        try {
            return (GalaxyQueryUserSeriesNftListReqDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxyQueryUserSeriesNftListReqDto();
        }
    }
}
