package com.liquidnet.service.kylin.service.impl;

import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.goblin.dto.manage.vo.AnticipateValueVo;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinGoodsAnticipateValueVo;
import com.liquidnet.service.goblin.dto.vo.*;
import com.liquidnet.service.kylin.dto.vo.KylinRecommendActiveRelationVo;
import com.liquidnet.service.kylin.dto.vo.KylinRecommendActiveVo;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinPerformanceVo;
import com.liquidnet.service.kylin.entity.KylinRecommendActive;
import com.liquidnet.service.kylin.entity.KylinRecommendActiveRelation;
import com.liquidnet.service.kylin.service.IKylinRecommendActiveService;
import com.liquidnet.service.kylin.utils.*;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.*;

/**
 *
 */
@Service
public class KylinRecommendActiveServiceImpl implements IKylinRecommendActiveService {
    @Autowired
    private DataUtils dataUtils;
    @Autowired
    private KylinRedisUtils kylinRedisUtils;
    @Autowired
    private GoblinOrderUtils goblinOrderUtils;
    @Autowired
    private KylinPerformancesServiceImpl kylinPerformancesService;

    @Override
    public KylinRecommendActiveVo getRecommendById(List<KylinRecommendActive> list) throws ParseException {
        for (KylinRecommendActive kylinRecommendActive : list) {
            //查看时间是否在当前范围内
            if (LocalDateTime.now().isAfter(kylinRecommendActive.getStartTime()) && LocalDateTime.now().isBefore(kylinRecommendActive.getEndTime())) {
                KylinRecommendActiveVo kylinRecommendActiveVo = KylinRecommendActiveVo.getNew();
                BeanUtils.copyProperties(kylinRecommendActive, kylinRecommendActiveVo);
                ArrayList<KylinRecommendActiveRelationVo> kylinRecommendActiveRelationVoList = ObjectUtil.getKylinRecommendActiveRelationVo();
                for (KylinRecommendActiveRelation ky : kylinRecommendActive.getList()) {
                    KylinRecommendActiveRelationVo aNew = KylinRecommendActiveRelationVo.getNew();
                    BeanUtils.copyProperties(ky, aNew);
                    kylinRecommendActiveRelationVoList.add(aNew);
                }
                kylinRecommendActiveVo.setList(kylinRecommendActiveRelationVoList);
            /*    if(StringUtil.isNotBlank(kylinRecommendActiveVo.getActiveBindId())&&null !=kylinRecommendActiveVo.getActiveType()){
                    //找到绑定的详情
                    if(kylinRecommendActiveVo.getActiveType()==3){
                        //演出
                        KylinPerformanceVo performancesInfo = dataUtils.getPerformanceVo(kylinRecommendActiveVo.getActiveBindId());
                        kylinRecommendActiveVo.setKylinPerformanceVo(performancesInfo);
                    }else if(kylinRecommendActiveVo.getActiveType()==1){
                        //NFT
                        GoblinNftGoodsSkuInfoVo goblinNftGoodsSkuInfoVo=goodsDetail(kylinRecommendActiveVo.getActiveBindId());
                        com.liquidnet.service.kylin.dto.vo.GoblinNftGoodsSkuInfoVo aNew = com.liquidnet.service.kylin.dto.vo.GoblinNftGoodsSkuInfoVo.getNew();
                        BeanUtils.copyProperties(goblinNftGoodsSkuInfoVo,aNew);
                        kylinRecommendActiveVo.setGoblinNftGoodsSkuInfoVo(aNew);
                    }else if(kylinRecommendActiveVo.getActiveType()==4){
                        //商品
                        GoblinGoodsInfoVo goblinGoodsInfoVo = kylinRedisUtils.getGoodsInfoVo(kylinRecommendActiveVo.getActiveBindId());
                        com.liquidnet.service.kylin.dto.vo.GoblinGoodsInfoVo aNew = com.liquidnet.service.kylin.dto.vo.GoblinGoodsInfoVo.getNew();
                        BeanUtils.copyProperties(goblinGoodsInfoVo,aNew);
                        kylinRecommendActiveVo.setGoblinGoodsInfoVo(aNew);
                    }else if(kylinRecommendActiveVo.getActiveType()==2){
                        //组合购
                        GoblinMixAppDetailsVo goblinMixAppDetailsVo = mixDetails(kylinRecommendActiveVo.getActiveBindId());
                        com.liquidnet.service.kylin.dto.vo.GoblinMixAppDetailsVo aNew = com.liquidnet.service.kylin.dto.vo.GoblinMixAppDetailsVo.getNew();
                        BeanUtils.copyProperties(goblinMixAppDetailsVo,aNew);
                        kylinRecommendActiveVo.setGoblinMixAppDetailsVo(aNew);
                    }
                }*/
                //遍历list
                List<KylinRecommendActiveRelationVo> kylinRecommendActiveVoList = kylinRecommendActiveVo.getList();
                ListIterator<KylinRecommendActiveRelationVo> iterator=kylinRecommendActiveVoList.listIterator();
                while (iterator.hasNext()) {
                    KylinRecommendActiveRelationVo kylinRecommendActiveRelationVo =iterator.next();
                    if (kylinRecommendActiveRelationVo.getType() == 1) {
                        //NFT
                        GoblinNftGoodsSkuInfoVo goblinNftGoodsSkuInfoVo = goodsDetail(kylinRecommendActiveRelationVo.getRecommendBindId());
                        if (null != goblinNftGoodsSkuInfoVo) {
                            com.liquidnet.service.kylin.dto.vo.GoblinNftGoodsSkuInfoVo aNew = com.liquidnet.service.kylin.dto.vo.GoblinNftGoodsSkuInfoVo.getNew();
                            GoblinGoodsInfoVo goodsInfoVo = kylinRedisUtils.getGoodsInfoVo(goblinNftGoodsSkuInfoVo.getSpuId());
                            BeanUtils.copyProperties(goblinNftGoodsSkuInfoVo, aNew);
                            aNew.setAuthor(goodsInfoVo.getAuthor());
                            aNew.setPublisher(goodsInfoVo.getPublisher());
                            kylinRecommendActiveRelationVo.setGoblinNftGoodsSkuInfoVo(aNew);
                            kylinRecommendActiveRelationVo.setCount(true);
                        }else{
                            kylinRecommendActiveRelationVo.setCount(false);
                            iterator.remove();
                        }
                    } else if (kylinRecommendActiveRelationVo.getType() == 2) {
                        //组合购
                        GoblinMixAppDetailsVo goblinMixAppDetailsVo = mixDetails(kylinRecommendActiveRelationVo.getRecommendBindId());
                        if (null != goblinMixAppDetailsVo) {
                            com.liquidnet.service.kylin.dto.vo.GoblinMixAppDetailsVo aNew = com.liquidnet.service.kylin.dto.vo.GoblinMixAppDetailsVo.getNew();
                            BeanUtils.copyProperties(goblinMixAppDetailsVo, aNew);
                            if(goblinMixAppDetailsVo.getStatus()!=7&&comparTime(aNew.getShelvesTime(),aNew.getTimeEnd())){
                                kylinRecommendActiveRelationVo.setGoblinMixAppDetailsVo(aNew);
                                kylinRecommendActiveRelationVo.setCount(true);
                            }else{
                                kylinRecommendActiveRelationVo.setCount(false);
                                iterator.remove();
                            }
                        }else{
                            kylinRecommendActiveRelationVo.setCount(false);
                            iterator.remove();
                        }
                    } else if (kylinRecommendActiveRelationVo.getType() == 3) {
                        //演出
                        KylinPerformanceVo performancesInfo = dataUtils.getPerformanceVo(kylinRecommendActiveRelationVo.getRecommendBindId());
                        if(null!=performancesInfo){
                            List<KylinPerformanceVo> newList = ObjectUtil.getKylinPerformanceVoArrayList();
                            newList.add(performancesInfo);
                            List<KylinPerformanceVo> kylinPerformanceVos = kylinPerformancesService.checkAppStatus(newList);
                            if(null!=performancesInfo.getIsShow()&&performancesInfo.getIsShow()==0){kylinPerformanceVos=null; }
                            if(null!=kylinPerformanceVos&&kylinPerformanceVos.size()>0){
                                performancesInfo=kylinPerformanceVos.get(0);
                                kylinRecommendActiveRelationVo.setKylinPerformanceVo(performancesInfo);
                                kylinRecommendActiveRelationVo.setCount(true);
                            }else{
                                kylinRecommendActiveRelationVo.setCount(false);
                                iterator.remove();
                            }
                        }else{
                            kylinRecommendActiveRelationVo.setCount(false);
                            iterator.remove();
                        }
                      /*  if(null!=performancesInfo){
                            if(performancesInfo.getAppStatus()!=7&&performancesInfo.getAppStatus()!=10){
                                kylinRecommendActiveRelationVo.setKylinPerformanceVo(performancesInfo);
                                kylinRecommendActiveRelationVo.setCount(true);
                            }else{
                                kylinRecommendActiveRelationVo.setCount(false);
                                iterator.remove();
                            }
                        }else{
                            kylinRecommendActiveRelationVo.setCount(false);
                            iterator.remove();
                        }*/
                    } else if (kylinRecommendActiveRelationVo.getType() == 4) {
                        //商品               //商品
                        GoblinGoodsInfoVo goblinGoodsInfoVo = kylinRedisUtils.getGoodsInfoVo(kylinRecommendActiveRelationVo.getRecommendBindId());
                        if (null != goblinGoodsInfoVo) {
                            if(goblinGoodsInfoVo.getShelvesStatus().equals("3")&&goblinGoodsInfoVo.getSpuAppear().equals("0")){
                                com.liquidnet.service.kylin.dto.vo.GoblinGoodsInfoVo aNew = com.liquidnet.service.kylin.dto.vo.GoblinGoodsInfoVo.getNew();
                                BeanUtils.copyProperties(goblinGoodsInfoVo, aNew);
                                kylinRecommendActiveRelationVo.setGoblinGoodsInfoVo(aNew);
                                kylinRecommendActiveRelationVo.setCount(true);
                            }else{
                                kylinRecommendActiveRelationVo.setCount(false);
                                iterator.remove();
                            }
                        }else{
                            kylinRecommendActiveRelationVo.setCount(false);
                            iterator.remove();
                        }
                }
                   /* for (KylinRecommendActiveRelationVo kylinRecommendActiveRelationVo : kylinRecommendActiveVoList) {

                    }*/
                }
                return kylinRecommendActiveVo;
            }
        }
        return null;
    }
    public boolean comparTime(String startTime,String endTime) throws ParseException {
        if(StringUtil.isNotBlank(startTime)&&StringUtil.isNotBlank(endTime)){
            SimpleDateFormat sdf = DateUtil.SDF_YMD_HMS;
            Date d= new Date();
            if(d.compareTo(sdf.parse(startTime))>0&&d.compareTo(sdf.parse(endTime))<0){
                return true;
            }
        }
        return false;
    }
    // 各种状态下判断藏品是否可以展示
    public boolean getSkuAllStatusShow(GoblinGoodsSkuInfoVo info) {
        if (
                info != null
                        && info.getSkuType() == 1
                        && info.getStatus().equals("3")
                        && info.getShelvesStatus().equals("3")
                        && (info.getSkuAppear() == null || info.getSkuAppear().equals("0"))
                        && info.getDelFlg().equals("0")
                        && ((info.getUnbox().equals("0") && info.getUpchain() == 1) || info.getUnbox().equals("1"))
            // && (info.getUnbox().equals("1") || info.getUpchain() == 1)
        ) {
            return true;
        } else {
            return false;
        }
    }

    public static void main(String[] args) throws ParseException {
        KylinRecommendActiveServiceImpl a=new KylinRecommendActiveServiceImpl();
        boolean b = a.comparTime("2020-12-01 00:00:00", "2022-12-01 00:00:00");
        System.out.println(b);
       /* //LocalDate a=new LocalDate("2009-12-31 12:00:00");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date1 = sdf.parse("2009-12-31 12:00:00");
        Date date2 = sdf.parse("2023-01-31 12:00:00");
        Date date = new Date();
        System.out.println(date.compareTo(date1));
        System.out.println(date.compareTo(date2));*/
    }

    public AnticipateValueVo getAnticipateValueBySkuId(String skuId, int hasHead) {
        GoblinGoodsAnticipateValueVo anticipateValueVo = kylinRedisUtils.getValueBySkuId(skuId);
        AnticipateValueVo valueVo = AnticipateValueVo.getNew();
        if (anticipateValueVo != null) {
            valueVo = valueVo.copy(anticipateValueVo);
            valueVo.setState(GoblinAnticipateUtils.setState(valueVo.getAboutStartDate(), valueVo.getAboutEndDate()));
        } else {
            valueVo.setState(null);
            valueVo.setAboutEndDate(null);
            valueVo.setAboutStartDate(null);
            valueVo.setAboutPeople(BigInteger.ZERO);
            valueVo.setType(null);
            valueVo.setPeopleType(null);
            valueVo.setRule("");
        }
        if (hasHead == 1) {
            valueVo.setAboutAvatarList(kylinRedisUtils.getUserAvatar(skuId));
        } else {
            valueVo.setAboutAvatarList(CollectionUtil.linkedListString());
        }
        return valueVo;
    }
    /**
     * NFT 获取详情
     */
    public GoblinNftGoodsSkuInfoVo goodsDetail(String skuId) {
        // 1
        LocalDateTime now = LocalDateTime.now();
        HashMap<String, Object> map = kylinRedisUtils.getGoodsSkuInfoVo(now, skuId);
        if (null == map) {
            return null;
        }
        GoblinGoodsSkuInfoVo skuInfoVo = (GoblinGoodsSkuInfoVo) map.get("vo");
        Integer tagType = (Integer) map.get("tagType");
        String listId = (String) map.get("listId");
        LocalDateTime baseSaleStartTime = (LocalDateTime) map.get("baseSaleStartTime");
        LocalDateTime nextSaleStartTime = (LocalDateTime) map.get("nextSaleStartTime");
        if (kylinRedisUtils.getSkuAllStatusShow(skuInfoVo)) {
            //获取预约相关
            AnticipateValueVo anticipateValueVo = getAnticipateValueBySkuId(skuId, 1);

            GoblinNftGoodsSkuInfoVo nftGoodsSkuInfoVo = GoblinNftGoodsSkuInfoVo.getNew().copy(skuInfoVo, anticipateValueVo);
            // 限购数量
            Integer buyCount = 0;
            String userId = CurrentUtil.getCurrentUid();
            if (StringUtils.isNotBlank(userId)) {
                buyCount = kylinRedisUtils.getSkuCountByUid(userId, skuId);
            }
            if (null != skuInfoVo.getBuyLimit() && 0 != skuInfoVo.getBuyLimit()) {
                nftGoodsSkuInfoVo.setCanBuyNum(skuInfoVo.getBuyLimit() - buyCount);
            }
            // spu信息
            GoblinGoodsInfoVo goodsInfoVo = kylinRedisUtils.getGoodsInfoVo(skuInfoVo.getSpuId());
            GoblinNftGoodsDetailSpuInfoVo nftGoodsDetailSpuInfoVo = GoblinNftGoodsDetailSpuInfoVo.getNew().copy(goodsInfoVo);
            nftGoodsSkuInfoVo.setGoblinNftGoodsDetailSpuInfoVo(nftGoodsDetailSpuInfoVo);
            // 库存
            HashMap<String, Integer> stockHashMap = goblinOrderUtils.getIsStock(listId, skuId, skuInfoVo.getUnbox(), skuInfoVo.getSoldoutStatus(), goodsInfoVo.getSkuIdList());
            nftGoodsSkuInfoVo.setIsStock(stockHashMap.get("isStock"));
            // 总库存
            if (skuInfoVo.getUnbox().equals("1")) {
                nftGoodsSkuInfoVo.setSkuStock(stockHashMap.get("totalStock"));
            }
            // 系统时间
            nftGoodsSkuInfoVo.setSystime(LocalDateTime.now());
            nftGoodsSkuInfoVo.setTagType(tagType);
            nftGoodsSkuInfoVo.setListId(listId);
            nftGoodsSkuInfoVo.setBaseSaleStartTime(baseSaleStartTime);
            nftGoodsSkuInfoVo.setNextSaleStartTime(nextSaleStartTime);
            // 是否开启兑换
            nftGoodsSkuInfoVo.setIsExchange(kylinRedisUtils.getIsExchange(skuId));
            // 待支付订单数量
            nftGoodsSkuInfoVo.setNotPayNum(kylinRedisUtils.getNotPayNum(skuId, listId));
            return nftGoodsSkuInfoVo;
        } else {
            return null;
        }
    }

    public GoblinMixAppDetailsVo mixDetails(String mixId) {
        GoblinMixDetailsVo baseVo = kylinRedisUtils.getMixDetails(mixId);
        //GoblinStoreInfoVo storeInfoVo = redisUtils.getStoreInfoVo(baseVo.getStoreId());
        GoblinMixAppDetailsVo vo = GoblinMixAppDetailsVo.getNew().copy(baseVo, "");
        int stock = 0;
        for (GoblinMixDetailsItemVo item : vo.getItem()) {
            GoblinGoodsSkuInfoVo skuInfoVo = kylinRedisUtils.getGoodsSkuInfoVo(item.getSkuId());
            GoblinGoodsInfoVo spuInfoVo = kylinRedisUtils.getGoodsInfoVo(skuInfoVo.getSpuId());
            item.setSkuPic(skuInfoVo.getSkuPic());
            item.setStock(0);
            item.setSkuName(skuInfoVo.getName());
            item.setSpuName(spuInfoVo.getName());
            if (skuInfoVo.getUnbox().equals("1")) {
                List<String> relationIds = kylinRedisUtils.getGoblinMixRelationBox(item.getSkuId(), vo.getMixId());
                for (String skuId : relationIds) {
                    stock += kylinRedisUtils.getSkuStock(vo.getMixId(), skuId);
                }
            } else {
                stock += kylinRedisUtils.getSkuStock(vo.getMixId(), item.getSkuId());
            }
        }
        if (stock == 0) {
            vo.setStatus(8);
        } else {
            LocalDateTime nt = LocalDateTime.now();
            LocalDateTime st = LocalDateTime.parse(vo.getTimeStart(), DateUtil.DTF_YMD_HMS);
            LocalDateTime et = LocalDateTime.parse(vo.getTimeEnd(), DateUtil.DTF_YMD_HMS);
            if (nt.isBefore(st)) {
                vo.setStatus(9);
            } else if (nt.isAfter(et)) {
                vo.setStatus(10);
            } else {
                vo.setStatus(6);
            }
        }
        return vo;
    }
}
