package com.liquidnet.client.admin.web.controller.zhengzai.kylin;

import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.common.annotation.Log;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.common.enums.BusinessType;
import com.liquidnet.service.kylin.dao.PerformanceRecommendAdminDao;
import com.liquidnet.service.kylin.dao.PerformanceRecommendDao;
import com.liquidnet.service.kylin.dao.PerformanceTitleDao;
import com.liquidnet.service.kylin.service.admin.IKylinPerformancesAdminService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 演出Controller
 *
 * @author anjiabin
 * @date 2021-05-24
 */
@Controller
@RequestMapping("/kylin/performances/recommend")
public class KylinPerformancesRecommendController extends BaseController {
    private String prefix = "zhengzai/kylin/performances/recommend";

    @Autowired
    private IKylinPerformancesAdminService kylinPerformancesService;

//    @RequiresPermissions("kylin:performances:recommend")
    @GetMapping()
    public String recommend() {
        return prefix + "/recommend";
    }

    /**
     * 查询演出列表
     */
//    @RequiresPermissions("kylin:performances:recommend:list")
    @Log(title = "推荐演出", businessType = BusinessType.LIST)
    @PostMapping("/list")
    @ResponseBody
    public TableDataInfo list() {
        PageInfo<PerformanceRecommendAdminDao> result = kylinPerformancesService.listRecommend();
        return getDataTable(result.getList());
    }

    /**
     * 新增
     */
    @GetMapping("/add")
    public String add() {
        return prefix + "/add";
    }

    /**
     * 修改
     */
    @Log(title = "推荐演出", businessType = BusinessType.UPDATE)
//    @RequiresPermissions("kylin:performances:recommend:change")
    @PostMapping("/change")
    @ResponseBody
    public AjaxResult setRecommend(@RequestParam(value = "ids") String performancesId,@RequestParam(value = "isRecommend",required = false) Integer isRecommend) {
        boolean result = kylinPerformancesService.setRecommend(performancesId,isRecommend);
        return toAjax(result);
    }

    /**
     * 详情
     */
    @Log(title = "推荐演出", businessType = BusinessType.DETAIL)
    @GetMapping("/edit/{performancesId}")
    public String edit(@PathVariable("performancesId") String performancesId, ModelMap mmap) {
        PerformanceRecommendDao result = kylinPerformancesService.getRecommend(performancesId);
        mmap.put("performanceRecommendDao", result);
        return prefix + "/edit";
    }

//    @RequiresPermissions("kylin:performances:recommend:change")
    @Log(title = "推荐演出", businessType = BusinessType.LIST)
    @GetMapping(value = "/performance/status")
    @ResponseBody
    public AjaxResult listByStatus(@RequestParam(value = "status") String status,@RequestParam(value = "title",required = false) String title) {
        List<PerformanceTitleDao> result = kylinPerformancesService.getListByStatus(status,title);
        AjaxResult ajax = new AjaxResult();
        ajax.put("value", result);
        return ajax;
    }
}
