package com.liquidnet.common.third.xuper.dto;

import lombok.Data;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 拉取账户创造资产列表
 * @class: Xuper001GetStokenReqDto
 * @Package com.liquidnet.common.third.xuper.dto
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/4/18 15:10
 */
@Data
public class Xuper006ListAssetByAddrReqDto {
    //资产状态。0：全部 1：初试 3：发行中 4：发行成功。默认 0（可选）
    private Integer status = 0;
    //要拉取的区块链账户地址
    private String addr;
    //要拉取页数，第一页为1
    private Integer page = 1;
    //每页拉取数量，默认20，最大50（可选）
    private Integer limit = 20;

    private static final Xuper006ListAssetByAddrReqDto obj = new Xuper006ListAssetByAddrReqDto();
    public static Xuper006ListAssetByAddrReqDto getNew() {
        try {
            return (Xuper006ListAssetByAddrReqDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new Xuper006ListAssetByAddrReqDto();
        }
    }
}
