package com.liquidnet.common.third.zxlnft.dto;

import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 46.NFT 转移
 * @class: NftTransferReq
 * @Package com.liquidnet.common.third.zxlnft.dto.nft
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/2/18 15:55
 */
@Data
public class Nft046TransferReqDto implements Serializable {
    /**
     * nft可操作者的公钥
     */
    private String pubKey;
    /**
     * nft接收者的地址
     */
    private String receiverAddr;
    /**
     * 要转移的nftId
     */
    private String nftId;
    /**
     * 请求ID，每个请求需要填唯一的ID，重复请求用相同的id
     */
    private String operateId;
    /**
     * 操作者的私钥签名，签名对象是(pubKey_receiverAddr_接口名_nftId_operateId)
     * 接口名：nft_transfer
     */
    private String signature;
    private static final Nft046TransferReqDto obj = new Nft046TransferReqDto();
    private static final long serialVersionUID = 5402657568879301374L;

    public static Nft046TransferReqDto getNew() {
        try {
            return (Nft046TransferReqDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new Nft046TransferReqDto();
        }
    }
}
