package com.liquidnet.service.goblin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 藏品转赠订单记录
 * </p>
 *
 * @author liquidnet
 * @since 2022-08-26
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinNftTransferOrder implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 转赠订单号
     */
    private String orderId;

    /**
     * 藏品ID
     */
    private String artworkId;

    /**
     * 拥有人UID
     */
    private String ownerUid;

    /**
     * 受赠人UID
     */
    private String receiverUid;

    /**
     * 订单状态[0-等待接收|1-确认接收|2-拒绝接收|3-过期关闭]
     */
    private Integer state;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;

    private String comment;


}
