package com.liquidnet.client.admin.zhengzai.candy.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.client.admin.zhengzai.candy.service.ICandyMgtCouponAdminService;
import com.liquidnet.common.exception.LiquidnetServiceException;
import com.liquidnet.service.candy.dto.admin.CandyMgtCouponInfoDto;
import com.liquidnet.service.candy.dto.admin.CandyMgtCouponListParam;
import com.liquidnet.service.candy.entity.CandyCoupon;
import com.liquidnet.service.candy.entity.CandyMgtCoupon;
import com.liquidnet.service.candy.mapper.CandyCouponMapper;
import com.liquidnet.service.candy.mapper.CandyMgtCouponMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Slf4j
@Service
public class CandyMgtCouponAdminServiceImpl extends ServiceImpl<CandyMgtCouponMapper, CandyMgtCoupon> implements ICandyMgtCouponAdminService {
    @Autowired
    private CandyMgtCouponMapper candyMgtCouponMapper;
    @Autowired
    private CandyCouponMapper candyCouponMapper;

    @Override
    @Transactional
    public void saveMgtCouponInfo(CandyCoupon initCoupon, CandyMgtCoupon initMgtCoupon) {
        int insert = candyCouponMapper.insert(initCoupon);
        insert += candyMgtCouponMapper.insert(initMgtCoupon);
        if (insert < 2) {
            throw new LiquidnetServiceException();
        }
    }

    @Override
    public List<CandyMgtCouponInfoDto> listForMgtCouponInfoDto(CandyMgtCouponListParam listParam) {
        return candyMgtCouponMapper.selectMultiForMgtCouponInfoDto(listParam);
    }
}
