package com.liquidnet.service.platform.service.impl.candy;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.candy.dto.CandyUserCouponBasicDto;
import com.liquidnet.service.candy.entity.CandyUserCoupon;
import com.liquidnet.service.candy.mapper.CandyUserCouponMapper;
import com.liquidnet.service.kylin.entity.KylinOrderTickets;
import com.liquidnet.service.platform.utils.QueueUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

@Service
public class PlatformCandyUserCouponService extends ServiceImpl<CandyUserCouponMapper, CandyUserCoupon> {

    @Autowired
    private PlatformCandyUserCouponService platformCandyUserCouponService;
    @Autowired
    private QueueUtils queueUtils;

    /**
     * @param uCouponUidList 内容 uCouponId,uid List
     * @param uCouponIdList  内容 uCouponId List
     * @return
     */
    public Boolean useBackCoupon(ArrayList<String> uCouponUidList, ArrayList<String> uCouponIdList) {
        //修改数据库
        CandyUserCoupon userCoupon = CandyUserCoupon.getNew();
        userCoupon.setState(1);
        platformCandyUserCouponService.update(userCoupon, new UpdateWrapper<CandyUserCoupon>().in("ucoupon_id", uCouponIdList));
        //sendRedis
        return true;
    }
}
