package com.liquidnet.service.sweet.dto.param.admin;

import com.liquidnet.service.sweet.entity.SweetIntegralActivityPrize;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 * SweetIntegralActivityPrizeFormParam
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-10-21
 */

@Data
@ApiModel(value = "SweetIntegralActivityPrizeFormParam", description = "积分活动创建奖品入参")
public class SweetIntegralActivityPrizeFormParam implements Serializable,Cloneable {

    private static final long serialVersionUID = 9194454546358707259L;

    @ApiModelProperty(value = "奖品id 创建不传 编辑必传", example = "429803743878963206506461")
    private String prizeId;

    @ApiModelProperty(value = "活动id[创建不传] 编辑必传", example = "1")
    private String integralActivityId;

    @ApiModelProperty(required = true, value = "奖品名称", example = "优惠券")
    @NotBlank(message = "prizeTitle不能为空")
    private String prizeTitle;

    @ApiModelProperty(required = false, value = "奖品描述", example = "奖品描述")
    private String prizeDescribe;

    @ApiModelProperty(required = true, value = "初始展示奖品图片", example = "test.png")
    @NotBlank(message = "prizeImgInit不能为空")
    private String prizeImgInit;

    @ApiModelProperty(required = true, value = "中奖选中奖品图片", example = "test.png")
    @NotBlank(message = "prizeImgSelect不能为空")
    private String prizeImgSelect;

    @ApiModelProperty(required = true, value = "奖品类型 1积分 2优惠券 3实物 4登登登VIP", example = "1")
    @NotNull(message = "prizeType不能为空")
    private Integer prizeType;

    @ApiModelProperty(required = false, value = "单次奖励数量如积分 中奖给多少物", example = "1")
    private Integer prizeTypeNum;

    @ApiModelProperty(required = true, value = "奖品数量", example = "100")
    @NotNull(message = "prizeNum不能为空")
    private Integer prizeNum;

    @ApiModelProperty(required = true, value = "是否是无限库存 1有限库存 2无限库存", example = "1")
    @NotNull(message = "isInfinite不能为空")
    private Integer isInfinite;

    @ApiModelProperty(required = true, value = "中奖概率", example = "1")
    @NotNull(message = "winningProbability不能为空")
    private BigDecimal winningProbability;

    private static final SweetIntegralActivityPrizeFormParam obj = new SweetIntegralActivityPrizeFormParam();

    public static SweetIntegralActivityPrizeFormParam getNew() {
        try {
            return (SweetIntegralActivityPrizeFormParam) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SweetIntegralActivityPrizeFormParam();
        }
    }

    public SweetIntegralActivityPrize copy(SweetIntegralActivityPrizeFormParam source) {
        SweetIntegralActivityPrize sweetIntegralActivityPrize = SweetIntegralActivityPrize.getNew();
        if (null == source) return null;
        sweetIntegralActivityPrize.setIntegralActivityId(source.getIntegralActivityId());
        sweetIntegralActivityPrize.setPrizeId(source.getPrizeId());
        sweetIntegralActivityPrize.setPrizeTitle(source.getPrizeTitle());
        sweetIntegralActivityPrize.setPrizeDescribe(source.getPrizeDescribe());
        sweetIntegralActivityPrize.setPrizeImgInit(source.getPrizeImgInit());
        sweetIntegralActivityPrize.setPrizeImgSelect(source.getPrizeImgSelect());
        sweetIntegralActivityPrize.setPrizeType(source.getPrizeType());
        sweetIntegralActivityPrize.setPrizeTypeNum(source.getPrizeTypeNum());
        sweetIntegralActivityPrize.setPrizeNum(source.getPrizeNum());
        sweetIntegralActivityPrize.setIsInfinite(source.getIsInfinite());
        sweetIntegralActivityPrize.setWinningProbability(source.getWinningProbability());
        return sweetIntegralActivityPrize;
    }

}
