package com.liquidnet.service.order.test;

import com.alibaba.fastjson.JSON;
import com.liquidnet.service.base.codec.util.CodecUtil;
import com.liquidnet.service.base.codec.vo.EncryptedReq;
import com.liquidnet.service.kylin.dto.param.PayOrderParam;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.util.Base64Utils;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: CodecTest
 * @Package com.liquidnet.service.order.test
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/7/6 12:29
 */
@Slf4j
@RunWith(SpringJUnit4ClassRunner.class)
@SpringBootTest
public class CodecTest {
    @Test
    public void testEncrypt(){
        System.out.println("CodecUtil.AES_SECRET_KEY_BYTES=== "+ Base64Utils.encodeToString(CodecUtil.AES_SECRET_KEY_BYTES));

        System.out.println(CodecUtil.sha1Encrypt("this is a test"));
        long timestamp = System.currentTimeMillis();
        System.out.println("时间戳：" + timestamp);
//        UserLoginReq userLoginReq = new UserLoginReq("admin", "admin");
//        String data = JSON.toJSONString(userLoginReq);
        String data = "{\"number\":1,\"ticketId\":\"2811887059054592999181\",\"isElectronic\":1,\"isExpress\":0,\"deviceFrom\":\"wap\",\"actual\":0.01,\"performanceId\":\"2811713813327872196937\",\"timeId\":\"2811766812553216086853\",\"returnUrl\":\"http://testm.zhengzai.tv/#/order/status?order_type=ticket&order_id=\",\"showUrl\":\"http://testm.zhengzai.tv/#/order/status?order_type=ticket&order_id=\",\"expressType\":2,\"agentId\":0,\"payType\":\"alipay\"}";
        System.out.println("加密前的数据：" + data);
        String encryptedData = CodecUtil.aesEncrypt(data);
        System.out.println("加密后的数据：" + encryptedData);
        String sign = CodecUtil.sha1Encrypt(encryptedData + timestamp);
        System.out.println("签名：" + sign);
        EncryptedReq<PayOrderParam> encryptedReq = new EncryptedReq<>();
        encryptedReq.setEncryptedData(encryptedData);
        encryptedReq.setTimestamp(timestamp);
        encryptedReq.setSign(sign);
        System.out.println("加密后的请求：" + JSON.toJSONString(encryptedReq));
    }
}
