package com.liquidnet.service.galaxy.router.strategy.biz;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyCommonBiz
 * @Package com.liquidnet.service.galaxy.router.strategy.biz
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/3/23 11:20
 */
@Slf4j
@Component
public class GalaxyCommonBiz {
    @Value("${liquidnet.galaxy.temp-file-path:/Users/anjiabin/mdsky_gitlab/galaxy/tempFilePath}")
    private String tempFilePath;

    /**
     * 通过URL上传
     * @param url
     * @param name
     * @return
     */
    public File inputStreamToFile(String url, String name) {
        try {
            HttpURLConnection httpUrl = (HttpURLConnection) new URL(url).openConnection();
            httpUrl.connect();
            InputStream ins = httpUrl.getInputStream();
//            File file = new File(System.getProperty("java.io.tmpdir") + File.separator + name);
            File file = new File(tempFilePath + File.separator + name);
            if (file.exists()) {
                return file;
            }
            OutputStream os = new FileOutputStream(file);
            int bytesRead;
            int len = 8192;
            byte[] buffer = new byte[len];
            while ((bytesRead = ins.read(buffer, 0, len)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
            os.close();
            ins.close();
            return file;
        } catch (Exception e) {
            log.error("inputStreamToFileUrlError", e);
            return null;
        }
    }
}
