package com.liquidnet.service.sweet.controller;


import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.dto.SweetManualArtistListDto;
import com.liquidnet.service.sweet.dto.SweetManualArtistListMDSKDto;
import com.liquidnet.service.sweet.service.ISweetManualArtistsMdskService;
import com.liquidnet.service.sweet.service.ISweetManualArtistsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 电子宣传手册艺人表 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2021-08-09
 */
@Api(tags = "电子手册艺人_MDSK")
@RestController
@RequestMapping("/mdsk/sweet-manual-artists")
public class SweetManualArtistsMdskController {

    @Autowired
    private ISweetManualArtistsMdskService sweetManualArtistsMdskService;

    @GetMapping("getList")
    @ApiOperation("宣传手册艺人列表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "page", value = "页数", required = true),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "size", value = "数量", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "manaulId", value = "手册id", required = true),
    })
    public ResponseDto<PageInfo<SweetManualArtistListMDSKDto>> getList(@RequestParam() Integer page,
                                                                       @RequestParam() Integer size,
                                                                       @RequestParam() String manualId) {
        return sweetManualArtistsMdskService.getList(page, size, manualId);
    }

    @GetMapping("details")
    @ApiOperation("宣传手册艺人详情")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualRelationId", value = "手册艺人id", required = true),
    })
    public ResponseDto<SweetManualArtistListMDSKDto> details(@RequestParam() String manualRelationId) {
        return sweetManualArtistsMdskService.details(manualRelationId);
    }

    @PostMapping("add")
    @ApiOperation("宣传手册艺人添加")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualId", value = "手册id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "artistId", value = "艺人id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "stageId", value = "场地id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "performanceStart", value = "演出开始时间", required = false),
            @ApiImplicitParam(type = "query", dataType = "String", name = "performanceEnd", value = "演出结束时间", required = false),
            @ApiImplicitParam(type = "query", dataType = "String", name = "signatureStart", value = "签售开始时间", required = false),
            @ApiImplicitParam(type = "query", dataType = "String", name = "signatureEnd", value = "签售结束时间", required = false),
    })
    public ResponseDto<Boolean> add(@RequestParam() String manualId,
                                    @RequestParam() String artistId,
                                    @RequestParam() String stageId,
                                    @RequestParam( required = false) String performanceStart,
                                    @RequestParam( required = false) String performanceEnd,
                                    @RequestParam( required = false) String signatureStart,
                                    @RequestParam( required = false) String signatureEnd) {
        return sweetManualArtistsMdskService.add(manualId, artistId, stageId, performanceStart, performanceEnd, signatureStart, signatureEnd);
    }

    @PostMapping("change")
    @ApiOperation("宣传手册艺人修改")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualRelationId", value = "手册艺人id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualId", value = "手册id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "artistId", value = "艺人id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "stageId", value = "场地id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "performanceStart", value = "演出开始时间", required = false),
            @ApiImplicitParam(type = "query", dataType = "String", name = "performanceEnd", value = "演出结束时间", required = false),
            @ApiImplicitParam(type = "query", dataType = "String", name = "signatureStart", value = "签售开始时间", required = false),
            @ApiImplicitParam(type = "query", dataType = "String", name = "signatureEnd", value = "签售结束时间", required = false),
    })
    public ResponseDto<Boolean> change(@RequestParam() String manualRelationId,
                                       @RequestParam() String manualId,
                                       @RequestParam() String artistId,
                                       @RequestParam() String stageId,
                                       @RequestParam( required = false) String performanceStart,
                                       @RequestParam( required = false) String performanceEnd,
                                       @RequestParam( required = false) String signatureStart,
                                       @RequestParam(required = false) String signatureEnd) {
        return sweetManualArtistsMdskService.change(manualRelationId, manualId, artistId, stageId, performanceStart, performanceEnd, signatureStart, signatureEnd);
    }

    @DeleteMapping("delete")
    @ApiOperation("宣传手册艺人删除")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualRelationId", value = "手册艺人id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualId", value = "手册id", required = true)
    })
    public ResponseDto<Boolean> delete(@RequestParam() String manualRelationId,
                                       @RequestParam() String manualId) {
        return sweetManualArtistsMdskService.delete(manualRelationId, manualId);
    }

}
