package com.liquidnet.service.goblin.service.impl.inner;

import com.liquidnet.common.cache.redis.util.RedisDataSourceUtil;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.galaxy.dto.param.GalaxyArtSeriesClaimReqDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyArtSeriesClaimRespDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyNftUploadReqDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyNftUploadRespDto;
import com.liquidnet.service.galaxy.service.IGalaxyArtworkService;
import com.liquidnet.service.goblin.constant.GoblinRedisConst;
import com.liquidnet.service.goblin.dto.vo.GoblinGoodsInfoVo;
import com.liquidnet.service.goblin.dto.vo.GoblinGoodsSkuInfoVo;
import com.liquidnet.service.goblin.util.GoblinMongoUtils;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import com.liquidnet.service.goblin.util.QueueUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.redis.connection.stream.StreamRecords;
import org.springframework.data.redis.core.StreamOperations;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.LinkedList;

@Slf4j
@Service
public class GoblinQueBizArtworkUplService {
    @Autowired
    QueueUtils queueUtils;
    @Autowired
    GoblinRedisUtils goblinRedisUtils;
    @Autowired
    GoblinMongoUtils goblinMongoUtils;
    @Autowired
    MongoTemplate mongoTemplate;

    @Autowired
    private RedisDataSourceUtil redisDataSourceUtil;

    @Resource(name = "galaxyArtworkServiceImpl")
    private IGalaxyArtworkService galaxyArtworkService;

    private static final String SQL_UPDATE_GOODS_SKU_NFT = "UPDATE goblin_goods_sku_nft SET upchain=?,display_url=?,nft_url=? WHERE sku_id=? AND upchain=0 ";

    public ResponseDto<String> bizArtworkUplProcessing(String skuId) {
        try {
            GoblinGoodsSkuInfoVo mgtGoodsSkuInfoVo = goblinMongoUtils.getGoodsSkuInfoVo(skuId);
            if (null == mgtGoodsSkuInfoVo) {
                log.warn("#藏品素材上传:藏品SKU不存在[skuId={}]", skuId);
                return ResponseDto.success(String.format("藏品SKU不存在[skuId:%s]", skuId));
            }
            int skuType = mgtGoodsSkuInfoVo.getSkuType(), upchain = mgtGoodsSkuInfoVo.getUpchain();
            String unbox = mgtGoodsSkuInfoVo.getUnbox();
            // 非数字藏品 || 盲盒 || 非声明中 || 已有声明系列ID
            if (1 != skuType || !"0".equals(unbox) || 0 != upchain || StringUtils.isNotEmpty(mgtGoodsSkuInfoVo.getSeriesId())) {
                log.warn("#藏品素材上传:藏品SKU无效或已声明[skuId={},skuType={},unbox={},upchain={},seriesId={}]",
                        skuId, skuType, unbox, upchain, mgtGoodsSkuInfoVo.getSeriesId());
                return ResponseDto.success(String.format("藏品SKU无效或已声明[skuId:%s]", skuId));
            }

            String displayUrl = mgtGoodsSkuInfoVo.getDisplayUrl(), nftUrl = mgtGoodsSkuInfoVo.getNftUrl();
            if (StringUtils.isBlank(displayUrl)) {// 未上传过的直接上传处理，已上传过的跳过上传直接声明
                GalaxyNftUploadReqDto galaxyNftUploadReqDto = GalaxyNftUploadReqDto.getNew();
                galaxyNftUploadReqDto.setSkuId(skuId);
                galaxyNftUploadReqDto.setOriginalDisplayUrl(mgtGoodsSkuInfoVo.getSkuPic());
                galaxyNftUploadReqDto.setOriginalNftUrl(mgtGoodsSkuInfoVo.getMaterialUrl());
                galaxyNftUploadReqDto.setRouterType(mgtGoodsSkuInfoVo.getRouteType());
                GalaxyNftUploadRespDto galaxyNftUploadRespDto = this.uploadNftMaterial(galaxyNftUploadReqDto);
                if (null == galaxyNftUploadRespDto) {
                    queueUtils.sendMsgByRedis(MQConst.GoblinQueue.BIZ_ARTWORK_UPL.getKey(), skuId);
                    return ResponseDto.failure(String.format("藏品上传失败[skuId:%s]", skuId));// 上传失败，重新入队处理
                }

                displayUrl = galaxyNftUploadRespDto.getDisplayUrl();
                nftUrl = galaxyNftUploadRespDto.getNftUrl();
            }

            GoblinGoodsInfoVo mgtGoodsInfoVo = goblinMongoUtils.getGoodsInfoVo(mgtGoodsSkuInfoVo.getSpuId());
            String skuTitle = mgtGoodsSkuInfoVo.getName() + mgtGoodsSkuInfoVo.getSubtitle();
            GalaxyArtSeriesClaimReqDto galaxyArtSeriesClaimReqDto = GalaxyArtSeriesClaimReqDto.getNew();
            galaxyArtSeriesClaimReqDto.setAuthor(mgtGoodsInfoVo.getAuthor());
            galaxyArtSeriesClaimReqDto.setCoverUrl(displayUrl);
            galaxyArtSeriesClaimReqDto.setDisplayUrl(displayUrl);
            galaxyArtSeriesClaimReqDto.setNftDesc(skuTitle);
            galaxyArtSeriesClaimReqDto.setNftName(skuTitle);
            galaxyArtSeriesClaimReqDto.setNftUrl(nftUrl);
            galaxyArtSeriesClaimReqDto.setRouterType(mgtGoodsSkuInfoVo.getRouteType());
            galaxyArtSeriesClaimReqDto.setSellCount(String.valueOf(mgtGoodsSkuInfoVo.getPrice()));
            galaxyArtSeriesClaimReqDto.setSeriesDesc(skuTitle);
            galaxyArtSeriesClaimReqDto.setSkuId(skuId);
            galaxyArtSeriesClaimReqDto.setTotalCount(Long.valueOf(mgtGoodsSkuInfoVo.getSkuStock()));

            // 声明失败，标记`声明失败`
            upchain = null == this.claimNftSeries(galaxyArtSeriesClaimReqDto) ? 2 : 9;

            mongoTemplate.getCollection(GoblinGoodsSkuInfoVo.class.getSimpleName()).updateOne(
                    Query.query(Criteria.where("skuId").is(skuId).and("delFlg").is("0")).getQueryObject(),
                    Update.update("upchain", upchain).set("displayUrl", displayUrl).set("nftUrl", nftUrl).getUpdateObject()
            );
            goblinRedisUtils.del(GoblinRedisConst.BASIC_GOODS_SKU.concat(skuId));

            // Mysql持久化
            HashMap<String, String> sqlUpdateMap = CollectionUtil.mapStringString();
            LinkedList<String> toMqSqls = CollectionUtil.linkedListString();
            toMqSqls.add(SQL_UPDATE_GOODS_SKU_NFT);
            LinkedList<Object[]> updateGoodsSkuNftObjs = CollectionUtil.linkedListObjectArr();
            updateGoodsSkuNftObjs.add(new Object[]{upchain, displayUrl, nftUrl, skuId});

            sqlUpdateMap.put(MQConst.QUEUE_MESSAGE_KEY, SqlMapping.gets(toMqSqls, updateGoodsSkuNftObjs));

            StreamOperations<String, Object, Object> streamOperations = redisDataSourceUtil.getRedisQueueUtil().getStringRedisTemplate().opsForStream();
            streamOperations.add(StreamRecords.mapBacked(sqlUpdateMap).withStreamKey(MQConst.GoblinQueue.SQL_GOODS.getKey()));

            HashMap<String, String> toQueueBeClaimQueryMsg = CollectionUtil.mapStringString();
            toQueueBeClaimQueryMsg.put(MQConst.QUEUE_MESSAGE_KEY, skuId.concat(",").concat(String.valueOf(LocalDateTime.now())));
            streamOperations.add(StreamRecords.mapBacked(toQueueBeClaimQueryMsg).withStreamKey(MQConst.GoblinQueue.BIZ_ARTWORK_CLQ.getKey()));
        } catch (Exception e) {
            log.error("Ex.藏品素材上传:处理异常[skuId={}]", skuId, e);
            queueUtils.sendMsgByRedis(MQConst.GoblinQueue.BIZ_ARTWORK_UPL.getKey(), skuId);
            return ResponseDto.failure(String.format("藏品上传异常[skuId:%s]", skuId));
        }
        return ResponseDto.success();
    }

    /* ------------------------------------------------------------------------------------ */
    /* ------------------------------------------------------------------------------------ */
    /* ------------------------------------------------------------------------------------ */
    /* ------------------------------------------------------------------------------------ */
    /* ------------------------------------------------------------------------------------ */

    /**
     * 藏品素材上传
     *
     * @param nftUploadReqDto GalaxyNftUploadReqDto
     * @return GalaxyNftUploadRespDto
     */
    private GalaxyNftUploadRespDto uploadNftMaterial(GalaxyNftUploadReqDto nftUploadReqDto) {
        ResponseDto<GalaxyNftUploadRespDto> responseDto = null;
        try {
            responseDto = galaxyArtworkService.nftUpload(nftUploadReqDto);
            if (!responseDto.isSuccess()) {
                log.warn("#藏品素材上传:处理失败[paramsStr={},postRespStr={}]", JsonUtils.toJson(nftUploadReqDto), JsonUtils.toJson(responseDto));
                return null;
            }
            return responseDto.getData();
        } catch (Exception e) {
            log.error("Ex.藏品素材上传:处理异常[paramsStr={},postRespStr={}],ex:{}", JsonUtils.toJson(nftUploadReqDto), JsonUtils.toJson(responseDto), e.getMessage());
            return null;
        }
    }

    /**
     * NFT系列声明
     *
     * @param requestDto GalaxyArtSeriesClaimReqDto
     * @return GalaxyArtSeriesClaimRespDto
     */
    private GalaxyArtSeriesClaimRespDto claimNftSeries(GalaxyArtSeriesClaimReqDto requestDto) {
        ResponseDto<GalaxyArtSeriesClaimRespDto> responseDto = null;
        try {
            responseDto = galaxyArtworkService.seriesClaim(requestDto);
            if (!responseDto.isSuccess()) {
                log.warn("#藏品系列声明:处理失败[paramsStr={},postRespStr={}]", JsonUtils.toJson(requestDto), JsonUtils.toJson(responseDto));
                return null;
            }
            return responseDto.getData();
        } catch (Exception e) {
            log.error("Ex.藏品系列声明:处理异常[paramsStr={},postRespStr={}],ex:{}", JsonUtils.toJson(requestDto), JsonUtils.toJson(responseDto), e.getMessage());
            return null;
        }
    }

    /* ------------------------------------------------------------------------------------ */
    /* ------------------------------------------------------------------------------------ */
    /* ------------------------------------------------------------------------------------ */
}
