package com.liquidnet.client.admin.web.controller.zhengzai.goblin;

import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.zhengzai.goblin.service.IGoblinZhengzaiMarketService;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.manage.GoblinStoreZhengzaiParam;
import com.liquidnet.service.goblin.dto.vo.GoblinZhengzaiVo;
import io.swagger.annotations.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * 商铺活动管理
 */
@Slf4j
@RestController
@Api(tags = "活动-正在下单")
@RequestMapping("goblin/marketing")
public class GoblinStorePurchasingController extends BaseController {

    @Autowired
    IGoblinZhengzaiMarketService goblinZhengzaiMarketService;

    @GetMapping("zhengzai/list")
    @ApiOperation("活动详情-正在下单列表")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = false, dataType = "Integer", name = "page", value = "页数", example = "1"),
            @ApiImplicitParam(type = "form", required = false, dataType = "String", name = "purchaseName", value = "活动名称", example = ""),
            @ApiImplicitParam(type = "form", required = false, dataType = "Integer", name = "status", value = "活动状态[-1-全部|0-等待开始|1-活动中|2-活动结束|7-停用]", example = ""),
            @ApiImplicitParam(type = "form", required = false, dataType = "String", name = "startTime", value = "活动开始时间", example = ""),
            @ApiImplicitParam(type = "form", required = false, dataType = "String", name = "endTime", value = "活动结束时间", example = ""),
            @ApiImplicitParam(type = "form", required = false, dataType = "String", name = "createdAt", value = "活动创建时间", example = ""),
    })
    public TableDataInfo purchasingList(@RequestParam(value = "page", required = false) @Valid Integer page,
                                        @RequestParam(value = "purchaseName", required = false) String purchaseName,
                                        @RequestParam(value = "status", required = false) Integer status,
                                        @RequestParam(value = "startTime", required = false) String st,
                                        @RequestParam(value = "endTime", required = false) String et,
                                        @RequestParam(value = "createdAt", required = false) String ct) {
        startPage();
        List<GoblinZhengzaiVo> list = goblinZhengzaiMarketService.zhengzaiList(page, purchaseName, status, st, et, ct).getData();
        return getDataTable(list);
    }

    @PutMapping("zhengzai/status")
    @ApiOperation("活动操作-正在下单")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "marketId", value = "活动id", example = "1"),
            @ApiImplicitParam(type = "form", required = true, dataType = "Integer", name = "status", value = "活动状态[0-等待开始|7-停用]", example = "0"),
    })
    public ResponseDto<Boolean> purchasingStatus(@RequestParam(value = "marketId") @Valid String marketId,
                                                 @RequestParam(value = "status") @Valid Integer status) {
        return goblinZhengzaiMarketService.zhengzaiStatus(marketId, status);
    }

    @PostMapping("zhengzai")
    @ApiOperation("创建活动-正在下单")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ResponseBody
    public ResponseDto<Boolean> purchasingInsert(GoblinStoreZhengzaiParam goblinStoreZhengzaiParam) {
        return goblinZhengzaiMarketService.zhengzaiInsert(goblinStoreZhengzaiParam.getName(), goblinStoreZhengzaiParam.getStoreId(), goblinStoreZhengzaiParam.getStartTime(), goblinStoreZhengzaiParam.getEndTime(), goblinStoreZhengzaiParam.getIsPre(), goblinStoreZhengzaiParam.getPreTime());
    }

    @PutMapping("zhengzai")
    @ApiOperation("修改活动-正在下单")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ResponseBody
    public ResponseDto<String> purchasingUpdate(GoblinStoreZhengzaiParam goblinStoreZhengzaiParam) {
        goblinZhengzaiMarketService.zhengzaiUpdate(goblinStoreZhengzaiParam.getMarketId(), goblinStoreZhengzaiParam.getName(), goblinStoreZhengzaiParam.getStoreId(), goblinStoreZhengzaiParam.getStartTime(), goblinStoreZhengzaiParam.getEndTime(), goblinStoreZhengzaiParam.getIsPre(), goblinStoreZhengzaiParam.getPreTime());
        return ResponseDto.success();
    }

    @GetMapping("zhengzai/details")
    @ApiOperation("活动详情-正在下单")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "marketId", value = "活动id", example = "1"),
    })
    public ResponseDto<GoblinZhengzaiVo> purchasingDetails(@RequestParam("marketId") @Valid String marketId) {
        return goblinZhengzaiMarketService.zhengzaiDetails(marketId);
    }

    @GetMapping("zhengzai/sku")
    @ApiOperation("活动详情-正在下单-店铺sku列表")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "marketId", value = "活动id", example = "1"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "storeId", value = "页数", example = "1"),
    })
    public ResponseDto<String> purchasingSkuList(@RequestParam("marketId") @Valid String marketId,
                                                 @RequestParam("storeId") @Valid String storeId) {
        return goblinZhengzaiMarketService.zhengzaiSkuList(marketId, storeId);
    }

    @DeleteMapping("zhengzai/sku")
    @ApiOperation("活动详情-正在下单-店铺sku删除")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "marketId", value = "活动id", example = "1"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "skuId", value = "skuId", example = "1"),
    })
    public ResponseDto<Boolean> purchasingSkuDel(@RequestParam("marketId") @Valid String marketId,
                                                 @RequestParam("skuId") @Valid String skuId) {
        return goblinZhengzaiMarketService.zhengzaiSkuDel(marketId, skuId);
    }

    @PostMapping("zhengzai/store")
    @ApiOperation("活动详情-正在下单-配置店铺")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "marketId", value = "活动id", example = "1"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "storeId", value = "商铺id", example = "1"),
            @ApiImplicitParam(type = "form", required = true, dataType = "Integet", name = "delTag", value = "删除标记[0-添加|1删除]", example = "0"),
    })
    public TableDataInfo purchasingSkuDel(@RequestParam("marketId") @Valid String marketId,
                                          @RequestParam("storeId") @Valid String storeId,
                                          @RequestParam("delTag") @Valid Integer delTag) {
        startPage();
        return getDataTable(goblinZhengzaiMarketService.zhengzaiStore(marketId, storeId, delTag).getData());
    }

    @DeleteMapping("zhengzai/store/sku")
    @ApiOperation("活动详情-正在下单-参加活动店铺列表")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "marketId", value = "活动id", example = "1"),
    })
    public ResponseDto<Boolean> purchasingSkuDel(@RequestParam("marketId") @Valid String marketId) {
        return goblinZhengzaiMarketService.zhengzaiStoreList(marketId);
    }
}
