package com.liquidnet.client.admin.zhengzai.goblin.service;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.manage.GoblinStorePurchaseItemParam;
import com.liquidnet.service.goblin.dto.vo.GoblinZhengzaiStoreListVo;
import com.liquidnet.service.goblin.dto.vo.GoblinZhengzaiVo;

import java.util.List;

/**
 * 正在下单相关
 */
public interface IGoblinZhengzaiMarketService {

    /**
     * 正在下单列表
     *
     * @param page         页数
     * @param purchaseName 活动名称
     * @param status       状态
     * @param st           开始时间
     * @param et           结束时间
     * @param ct           创建时间
     * @return
     */
    ResponseDto<List<GoblinZhengzaiVo>> zhengzaiList(int page, String purchaseName, int status, String st, String et, String ct);

    /**
     * 正在状态操作
     *
     * @param marketId 活动秒杀id
     * @param status   状态
     * @return
     */
    ResponseDto<Boolean> zhengzaiStatus(String marketId, int status);

    /**
     * 添加 正在下单活动
     *
     * @param purchaseName 秒杀活动名称
     * @param storeId      商铺id
     * @param st           开始时间
     * @param et           结束时间
     * @param isPre        是否预热
     * @param preTime      预热时间
     * @return
     */
    ResponseDto<Boolean> zhengzaiInsert(String purchaseName, String storeId, String st, String et, Integer isPre, String preTime);

    /**
     * @param marketId     活动id
     * @param purchaseName 秒杀活动名称
     * @param storeId      商铺id
     * @param st           开始时间
     * @param et           结束时间
     * @param isPre        是否预热
     * @param preTime      预热时间
     * @return
     */
    ResponseDto<Boolean> zhengzaiUpdate(String marketId, String purchaseName, String storeId, String st, String et, Integer isPre, String preTime);

    /**
     * 获取 限时秒杀 详情
     *
     * @param marketId 活动秒杀id
     * @return
     */
    ResponseDto<GoblinZhengzaiVo> zhengzaiDetails(String marketId);

    /**
     * 获取活动内sku列表
     *
     * @param marketId 活动秒杀id
     * @param storeId     页数
     * @return
     */
    ResponseDto<String> zhengzaiSkuList(String marketId, String storeId);//TODO 返回值

    /**
     * 删除活动内sku
     *
     * @param marketId 活动秒杀id
     * @param skuId    skuId
     * @return
     */
    ResponseDto<Boolean> zhengzaiSkuDel(String marketId, String skuId);


    /**
     * 添加正在下单 可参与活动店铺
     * @param marketId
     * @param storeId
     * @return
     */
    ResponseDto<List<GoblinZhengzaiStoreListVo>> zhengzaiStore(String marketId, String storeId, Integer delTag);

    /**
     * 查看详情(参加活动的商品列表)
     *
     * @param marketId
     * @return
     */
    ResponseDto<Boolean> zhengzaiStoreList(String marketId);//TODO


}
