package com.liquidnet.service.stone.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.commons.lang.util.HttpUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.adam.dto.vo.AdamUserInfoSimpleVo;
import com.liquidnet.service.base.ResponseDto;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.MultiValueMap;

/**
 * 内部接口调用工具类
 */
public class InnerUtils {
    @Value("${liquidnet.service.adam.url}")
    private String adamUrl;
    @Value("${liquidnet.service.candy.url}")
    private String candyUrl;

    public static AdamUserInfoSimpleVo getUserInfo() throws Exception {
        MultiValueMap<String, String> header = CollectionUtil.linkedMultiValueMapStringString();
        header.add("Authorization", "Bearer " + CurrentUtil.getToken());
        String resultData = HttpUtil.post("/adam/user/gif/mobile", null, header);
        ResponseDto<AdamUserInfoSimpleVo> innerReturnVo = JsonUtils.fromJson(resultData, new TypeReference<ResponseDto<AdamUserInfoSimpleVo>>() {
        });
        return innerReturnVo.getData();
    }
}
