package com.liquidnet.service.consumer.kylin.receiver;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.base.OrderCloseMapping;
import com.liquidnet.service.consumer.kylin.Utils.KylinUtils;
import com.liquidnet.service.kylin.constant.KylinRedisConst;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinOrderTicketEntitiesVo;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinOrderTicketVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.StreamRecords;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.stream.StreamListener;

import java.util.HashMap;

@Slf4j
public abstract class AbstractOptOrderTransferOverTimeRedisReceiver implements StreamListener<String, MapRecord<String, String, String>> {
    @Autowired
    StringRedisTemplate stringRedisTemplate;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private KylinUtils kylinUtils;

    @Override
    public void onMessage(MapRecord<String, String, String> message) {
        log.debug("CONSUMER SQL[streamKey:{},messageId:{},stream:{},body:{}]",
                this.getRedisStreamKey(), message.getId(), message.getStream(), message.getValue());

        boolean result = this.consumerOrderTransferOverTimeHandler(message.getValue().get("message"));
        log.info("CONSUMER SQL RESULT:{} ==> MESSAGE_ID:{}", result, message.getId());

        try {
            stringRedisTemplate.opsForStream().acknowledge(getRedisStreamGroup(), message);
            stringRedisTemplate.opsForStream().delete(this.getRedisStreamKey(), message.getId());
        } catch (Exception e) {
            log.error("#CONSUMER SQL RESULT:{} ==> DEL_REDIS_QUEUE_MSG_EXCEPTION[MESSAGE_ID:{},MSG:{}]", result, message.getId(), JsonUtils.toJson(message), e);
        } finally {
            try {
                stringRedisTemplate.opsForStream().acknowledge(getRedisStreamGroup(), message);
                stringRedisTemplate.opsForStream().delete(this.getRedisStreamKey(), message.getId());
            } catch (Exception ignored) {
            }
        }
    }

    private boolean consumerOrderTransferOverTimeHandler(String msg) {
        boolean aBoolean = false;
        try {
            OrderCloseMapping.orderCloseMessage mqMessage = JsonUtils.fromJson(msg, OrderCloseMapping.orderCloseMessage.class);
            if (mqMessage == null) {

            } else {
                for (int x = 0; x < mqMessage.getOrderTicketIds().size(); x++) {
                    String orderTicketId = mqMessage.getOrderTicketIds().get(x);
                    KylinOrderTicketVo vo = kylinUtils.getOrderTicketVo(orderTicketId);
                    String uid = vo.getTransferUid();
                    vo.setTransferUid("");
                    vo.setTransferStatus(0);
                    redisUtil.del(KylinRedisConst.ORDER_TRANSFER.concat(uid));
                    redisUtil.set("kylin:order:id:" + orderTicketId, vo);
                    kylinUtils.resetOrderListVo(vo.getUserId(), 2, orderTicketId, vo);
                }
            }
            aBoolean = true;
        } catch (Exception e) {
            log.error("CONSUMER SQL FAIL ==> {}", e.getMessage(), e);
        } finally {
            if (!aBoolean) {
                HashMap<String, String> map = CollectionUtil.mapStringString();
                map.put("message", msg);
                stringRedisTemplate.opsForStream().add(StreamRecords.mapBacked(map).withStreamKey(this.getRedisStreamKey()));
            }
        }
        return aBoolean;
    }

    protected abstract String getRedisStreamKey();

    protected abstract String getRedisStreamGroup();
}
