package com.liquidnet.service.stone.service.impl;

import com.github.pagehelper.PageInfo;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.UserPathDto;
import com.liquidnet.service.stone.entity.StoneScoreItems;
import com.liquidnet.service.stone.entity.StoneScoreLogs;
import com.liquidnet.service.stone.service.IStoneScoreLogsService;
import com.liquidnet.service.stone.util.ObjectUtils;
import com.liquidnet.service.stone.util.StoneMongoUtils;
import com.liquidnet.service.stone.util.StoneRedisUtils;
import com.liquidnet.service.stone.vo.StoneItemListVo;
import com.liquidnet.service.stone.vo.StoneLogsListVo;
import com.liquidnet.service.stone.vo.StoneTaskVo;
import com.liquidnet.service.stone.vo.StoneUserVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * <p>
 * 积分日志表 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-10-19
 */
@Service
@Slf4j
public class StoneScoreLogsServiceImpl implements IStoneScoreLogsService {

    @Autowired
    StoneRedisUtils stoneRedisUtils;
    @Autowired
    StoneMongoUtils stoneMongoUtils;

    @Override
    public String deScore(String uid, Integer score, Integer TaskId, String reason) {
        if (score <= 0) {
            return "积分不能小于0";
        }
        if (TaskId == 2111) {
            changeUse(uid, score, reason, reason);
            return "成功";
        } else {
            changeUse(uid, score, "", reason);
            return "成功";
        }
    }

    @Override
    public String inScore(String uid, Integer score, Integer TaskId, String reason) {
        if (score <= 0) {
            return "积分不能小于0";
        }
        if (TaskId == 2111) {
            changeRest(uid, score, reason, reason);
            return "成功";
        } else {
            changeRest(uid, score, "", reason);
            return "成功";
        }
    }

    @Override
    public ResponseDto<String> doTask(Integer taskId) {
        String uid = CurrentUtil.getCurrentUid();
        StoneUserVo vo = stoneRedisUtils.getUserData(uid);
        List<StoneTaskVo> taskList = vo.getTask();
        boolean isIn = false; //标示是否操作

        for (int i = 0; i < taskList.size(); i++) {
            StoneTaskVo item = taskList.get(i);
            //判断任务
            if (item.getTaskId().equals(taskId)) {
                if (item.getTaskType().equals(1) && item.getTaskTime().equals(DateUtil.getNowTime(DateUtil.DATE_SMALL_STR))) {
                    return ResponseDto.failure("今日已完成");
                } else if (item.getTaskType().equals(2) && item.getTaskCount() >= 1) {
                    return ResponseDto.failure("该任务已完成");
                } else {
                    //记录完成任务
                    if (taskId == 0) { //每日签到
                        if (DateUtil.intervalDays(DateUtil.parse(item.getTaskTime(), "yyyy-MM-dd"),
                                DateUtil.parse(DateUtil.getNowTime(), "yyyy-MM-dd")
                        ) == 1L) {//连续签到
                            if (item.getTaskCount() >= 7) {
                                item.setTaskCount(1);
                            } else {
                                item.setTaskCount(item.getTaskCount() + 1);
                            }
                        } else {//非连续签到
                            item.setTaskCount(1);
                        }
                    } else {//其他
                        item.setTaskCount(1);
                    }
                    item.setTaskTime(DateUtil.getNowTime(DateUtil.DATE_SMALL_STR));
                    taskList.set(i, item);
                    vo.setTask(taskList);
                    //mongo
                    stoneMongoUtils.userUpdateByUid(vo);
                    //redis
                    stoneRedisUtils.setUserData(uid,vo);
                    //添加积分
                    inScore(uid, taskId, taskId, item.getTaskName());
                    isIn = true;
                    break;
                }
            }
        }
        return isIn ? ResponseDto.success("成功") : ResponseDto.failure("任务不存在");
    }

    @Override
    public ResponseDto<StoneUserVo> taskDetail() {
        String uid = CurrentUtil.getCurrentUid();
        StoneUserVo vo = stoneRedisUtils.getUserData(uid);
        List<StoneTaskVo> taskList = vo.getTask();
        for (int i = 0; i < taskList.size(); i++) {
            StoneTaskVo item = taskList.get(i);
            if (item.getTaskType().equals(1) && item.getTaskTime().equals(DateUtil.getNowTime(DateUtil.DATE_SMALL_STR))) {
                item.setIsFinish(1);
            } else if (item.getTaskType().equals(2) && item.getTaskCount() >= 1) {
                item.setIsFinish(1);
            } else {
                item.setIsFinish(0);
            }
            taskList.set(i, item);
        }
        vo.setTask(taskList);
        return ResponseDto.success(vo);
    }

    @Override
    public PageInfo<List<StoneLogsListVo>> logList(Integer page) {
        String uid = CurrentUtil.getCurrentUid();
        PageInfo<List<StoneLogsListVo>> mPageInfo;
        int size = 40;
        if (page == null || page == 1 || page == 0) {
            page = 1;
        }
        List<StoneScoreLogs> voList;
        long count;
        if (page == 1) {
            voList = stoneRedisUtils.getLogsList(uid);
            count = voList.size();
        } else {
            HashMap<String, Object> info = stoneMongoUtils.itemListPage(page, size);
            try {
                voList = (List<StoneScoreLogs>) info.get("total");
                count = (long) info.get("data");
            } catch (Exception e) {
                voList = new ArrayList();
                count = 0;
            }
        }
        List<StoneLogsListVo> returnVoList = ObjectUtils.getStoneLogsListVoArrayList();
        for (int i = 0; i < voList.size(); i++) {
            StoneScoreLogs vo = voList.get(i);
            StoneLogsListVo returnVo = StoneLogsListVo.getNew().copy(vo);
            returnVoList.add(returnVo);
        }
        mPageInfo = new PageInfo(returnVoList);
        mPageInfo.setTotal(count);
        log.info(UserPathDto.setData("积分日志列表", "", voList));
        return mPageInfo;
    }

    private void changeRest(String uid, Integer score, String reason, String content) {
        //redis
        stoneRedisUtils.changeUserScoreRest(uid, score);
        //mongo
        StoneScoreLogs logs = new StoneScoreLogs();
        logs.setLogsId(IDGenerator.nextTimeId2());
        logs.setContent(content);
        logs.setReason(reason);
        logs.setUid(uid);
        logs.setScore(BigDecimal.valueOf(score));
        logs.setCreatedAt(LocalDateTime.now());
        stoneMongoUtils.logCreate(logs);
        //TODO mysql
    }

    private void changeUse(String uid, Integer score, String reason, String content) {
        //redis
        stoneRedisUtils.changeUserScoreUse(uid, -score);
        stoneRedisUtils.changeUserScoreRest(uid, -score);
        //mongo
        StoneScoreLogs logs = new StoneScoreLogs();
        logs.setLogsId(IDGenerator.nextTimeId2());
        logs.setContent(content);
        logs.setReason(reason);
        logs.setUid(uid);
        logs.setScore(BigDecimal.valueOf(score));
        logs.setCreatedAt(LocalDateTime.now());
        stoneMongoUtils.logCreate(logs);
        //TODO mysql
    }
}
