package com.liquidnet.service.executor.main.handler;

import com.liquidnet.commons.lang.util.HttpUtil;
import com.liquidnet.service.feign.kylin.task.FeignPlatformTaskClient;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.annotation.XxlJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * XxlJob开发示例（Bean模式）
 * <p>
 * 开发步骤：
 * 1、在Spring Bean实例中，开发Job方法，方式格式要求为 "public ReturnT<String> execute(String param)"
 * 2、为Job方法添加注解 "@XxlJob(value="自定义jobhandler名称", init = "JobHandler初始化方法", destroy = "JobHandler销毁方法")"，注解value值对应的是调度中心新建任务的JobHandler属性的值。
 * 3、执行日志：需要通过 "XxlJobLogger.log" 打印执行日志；
 */
@Component
public class KylinTaskHandler {
    private static final Logger log = LoggerFactory.getLogger(KylinTaskHandler.class);

    @Autowired
    private FeignPlatformTaskClient feignPlatformTaskClient;

    @XxlJob(value = "sev-platform:checkOrderTimeHandler")
    public ReturnT<String> checkOrderTimeHandler() {
        try {
            boolean result = feignPlatformTaskClient.checkOrderTime().getData();
            log.info("checkOrderTimeHandler：结果："+result);
            return ReturnT.SUCCESS;
        } catch (Exception e) {
            return ReturnT.FAIL;
        }
    }

    @XxlJob(value = "sev-platform:checkPerformanceTimeHandler")
    public ReturnT<String> checkPerformanceTimeHandler() {
        try {
            String result = feignPlatformTaskClient.checkPerformanceTime().getData();
            log.info("checkPerformanceTimeHandler：结果："+result);
            return ReturnT.SUCCESS;
        } catch (Exception e) {
            return ReturnT.FAIL;
        }
    }

    @XxlJob(value = "sev-platform:checkTransferOrderHandler")
    public ReturnT<String> checkTransferOrderHandler(@RequestParam Integer minute) {
        try {
            boolean result = feignPlatformTaskClient.checkTransferOrder(minute).getData();
            log.info("checkTransferOrderHandler：结果："+result);
            return ReturnT.SUCCESS;
        } catch (Exception e) {
            return ReturnT.FAIL;
        }
    }

//    @Autowired
//    private FeignSequenceClient feignSequenceClient;
//
//    @XxlJob(value = "sev-sequence:mainDemoJobHandler")
//    public ReturnT<String> mainDemoJobHandler(String param) {
//        log.info("liquidnet.mainDemoJobHandler");
//        Long test = feignSequenceClient.nextId();
//        log.info("test : " + test);
//        Long[] tests = feignSequenceClient.nextId(2);
//        log.info("tests: " + JSON.toJSONString(tests));
//        Long nextIncrId = feignSequenceClient.nextIncrId("SEQ_WL_N01_1784");
//        log.info("incrid:" + nextIncrId);
//        return ReturnT.SUCCESS;
//    }

//    @XxlJob(value = "sev-recon:accountCheckTask")
//    public ReturnT<String> accountCheckTask(String param) {
//        XxlJobLogger.log("start:liquidnet.accountCheckTask:[{}]", param);
//
//        String bankChannel = null;
//        String billDate = null;
//        if (!StringUtils.isEmpty(param)) {
//            JSONObject jsonParam = JSON.parseObject(param);
//            bankChannel = jsonParam.getString("bankChannel");
//            billDate = jsonParam.getString("billDate");
//        }
//        feignTaskReconAccountCheckClient.accountCheck(bankChannel,billDate);
//        XxlJobLogger.log("end:liquidnet.accountCheckTask:[{}]", JSON.toJSONString(ResponseDto.success()));
//        return ReturnT.SUCCESS;
//    }
}
