package com.liquidnet.service.kylin.dto.dao;

import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.commons.lang.util.ServletUtils;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
public class UserPathDao implements Serializable {

    private static final long serialVersionUID = -4153353929914805750L;
    private String tag;
    private String uid;
    private String token;
    private String time;//yyyyMMddHHmmssSSS
    private String interfaceName;
    private String params;
    private String result;
    private String ip;
    private String userAgent;

    public UserPathDao(LocalDateTime time, String interfaceName, Object params, Object result) {
        this.tag = "ANJIABIN";
        this.uid = CurrentUtil.getCurrentUid()==null?"UID":CurrentUtil.getCurrentUid();
        this.token = CurrentUtil.getToken()==null?"TOKEN":CurrentUtil.getToken();
        this.time = DateUtil.Formatter.yyyyMMddHHmmssSSS.format(time);
        this.interfaceName = interfaceName;
        this.params = params.toString();
        this.result = result.toString();
        this.ip = CurrentUtil.getCliIpAddr();
        this.userAgent = ServletUtils.getRequest().getHeader("User-Agent");
    }


    public String toString() {
        return JsonUtils.toJson(this);
    }
}
