package com.liquidnet.service.adam.service.processor;

import com.liquidnet.commons.lang.util.ServletUtils;
import com.liquidnet.service.adam.dto.vo.AdamMemberCodeVo;
import com.liquidnet.service.adam.entity.AdamMemberCode;
import com.liquidnet.service.adam.service.DataMigrationProcessorService;
import com.liquidnet.service.adam.service.IAdamMemberCodeService;
import com.mysql.cj.jdbc.result.ResultSetImpl;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Slf4j
@Service
public class DMMemberCodeProcessor extends DataMigrationProcessorService {
    @Autowired
    IAdamMemberCodeService adamMemberCodeService;

    private static Map<String, String> mMap = new HashMap<>();
    static {
        mMap.put("78","2159902978359319814V");
        mMap.put("93","2159903004882502855V");
        mMap.put("128","2159903083063113534V");
        mMap.put("171","2159903164279244032V");
        mMap.put("177","2159903178213564580V");
        mMap.put("201","2159903231304794843V");
        mMap.put("224","2159903286921267622V");
        mMap.put("278","2159903315535368620V");
        mMap.put("308","2159903325648681321V");
        mMap.put("371","2159903353285533024V");
        mMap.put("406","2159903365042471904V");
        mMap.put("448","2159903380066742978V");
        mMap.put("470","2159903389019474764V");
        mMap.put("514","2159903402623760508V");
        mMap.put("564","2159903420100480044V");
        mMap.put("566","2159903420815652272V");
        mMap.put("572","2159903425097220662V");
        mMap.put("584","2159903431725878110V");
        mMap.put("621","2159903445678115851V");
        mMap.put("625","2159903448130804563V");
        mMap.put("629","2159903449512021348V");
        mMap.put("634","2159903451797722527V");
        mMap.put("641","2159903456947872759V");
        mMap.put("649","2159903462764769342V");
        mMap.put("663","2159903470899755168V");
        mMap.put("670","2159903474711853726V");
        mMap.put("671","2159903474789135882V");
        mMap.put("692","2159903489229795967V");
        mMap.put("694","2159903491297244057V");
        mMap.put("724","2159903503090588386V");
        mMap.put("744","2159903517757370778V");
        mMap.put("753","2159903521221866688V");
        mMap.put("767","2159903529347024019V");
        mMap.put("812","2159903555573538568V");
        mMap.put("821","2159903560265023540V");
        mMap.put("831","2159903566740588324V");
        mMap.put("847","2159903574058019392V");
        mMap.put("880","2159903599623697117V");
        mMap.put("884","2159903605349638303V");
        mMap.put("893","2159903612326372870V");
        mMap.put("897","2159903630571607844V");
        mMap.put("899","2159903631906318964V");
        mMap.put("915","2159903663070164126V");
        mMap.put("925","2159903708638226752V");
        mMap.put("926","2159903709187446675V");
        mMap.put("929","2159903725057215138V");
        mMap.put("932","2159903733267427426V");
        mMap.put("934","2159903746991129377V");
        mMap.put("945","2159903899372919752V");
        mMap.put("946","2159903944921229059V");
        mMap.put("947","2159903973383580976V");
        mMap.put("948","2159904743264389337V");
        mMap.put("949","2159904881753208429V");
        mMap.put("950","2159905009806735836V");
        mMap.put("951","2159905284996580808V");
        mMap.put("952","2159905286677634113V");
        mMap.put("953","2159905455234006614V");
        mMap.put("954","2159905499349116774V");
        mMap.put("955","2159905536256825603V");
        mMap.put("956","2159906003655765269V");
        mMap.put("957","2159909717834813970V");
        mMap.put("958","2159910092253472736V");
        mMap.put("959","2159910193014350228V");
        mMap.put("960","2159910527370977102V");
        mMap.put("961","2159910531884733969V");
        mMap.put("962","2159910679489574768V");
        mMap.put("963","2159910910443346816V");
        mMap.put("964","2159912826218304603V");
        mMap.put("965","1599558421V");
        mMap.put("966","1599558422V");
        mMap.put("967","1599558423V");
        mMap.put("968","1599558424V");
        mMap.put("969","1599558425V");
        mMap.put("970","1599558426V");
        mMap.put("971","1599558427V");
        mMap.put("972","1599558428V");
        mMap.put("973","1599558429V");
        mMap.put("974","1599558431V");
        mMap.put("975","2159956316098104568V");
        mMap.put("976","2159956355872033001V");
        mMap.put("977","2159956860062026155V");
        mMap.put("978","2159957584538985726V");
        mMap.put("979","2159957623536849859V");
        mMap.put("980","2159957731800533965V");
        mMap.put("981","2159957840680405904V");
        mMap.put("982","2159957929849237090V");
        mMap.put("983","2159962320514458284V");
        mMap.put("984","1599631361V");
        mMap.put("985","1599631362V");
        mMap.put("986","1599631363V");
        mMap.put("987","1599631364V");
        mMap.put("988","1599631365V");
        mMap.put("989","1599631366V");
        mMap.put("990","1599631367V");
        mMap.put("991","1599631368V");
        mMap.put("992","1599631369V");
        mMap.put("993","1599631370V");
        mMap.put("994","2159963377631095182V");
        mMap.put("995","2159963692908504280V");
        mMap.put("996","2159963810907987285V");
        mMap.put("997","2159965666281774447V");
        mMap.put("1000","2159966779640863040V");
        mMap.put("1062","2159981484289308634V");
        mMap.put("1104","2159981487011831223V");
        mMap.put("1114","2159981487541782867V");
        mMap.put("1198","2159981493699630131V");
        mMap.put("1200","2159981493787551500V");
        mMap.put("1235","2159981500360161310V");
        mMap.put("1262","2159981509978829277V");
        mMap.put("1287","2159981524026090875V");
        mMap.put("1304","2159981536177567220V");
        mMap.put("1310","2159981545302191346V");
        mMap.put("1319","2159981554253166294V");
        mMap.put("1325","2159981560137685485V");
        mMap.put("1329","2159981563803933569V");
        mMap.put("1335","2159981573925532296V");
        mMap.put("1390","2159981688651814636V");
        mMap.put("1391","2159981690863703353V");
        mMap.put("1428","2159981809289823292V");
        mMap.put("1430","2159981818758016923V");
        mMap.put("1458","2159981953122687002V");
        mMap.put("1494","2159982351398865567V");
        mMap.put("1495","2159983504307869358V");
        mMap.put("1496","2159986673135905440V");
        mMap.put("1497","2159996274042898483V");
        mMap.put("1498","2160018496723049508V");
        mMap.put("1499","2160044520193237286V");
        mMap.put("1500","2160087799997486838V");
        mMap.put("2230","2160301409593379808V");
        mMap.put("2231","2160306912844638435V");
        mMap.put("2232","2160307407349758361V");
        mMap.put("2233","2160307601583764655V");
        mMap.put("2234","2160307779536228677V");
        mMap.put("2492","159963137111V");
        mMap.put("2510","2160327308412550248V");
        mMap.put("2515","2160327423681020972V");
        mMap.put("3359","2160447748642267709V");
        mMap.put("3360","2160464108681210878V");
        mMap.put("6315","2161440540017128902V");
        mMap.put("6511","2161535805626574069V");
        mMap.put("6726","2161571734236003828V");
        mMap.put("7629","2161675246646728746V");
        mMap.put("9150","2161891364918440203V");
        mMap.put("9554","2161900346985860326V");
        mMap.put("9888","2162037264105291340V");
        mMap.put("9889","2162037313688676374V");
        mMap.put("11470","2162202689894532474V");
    }

    @SneakyThrows
    @Override
    protected void dataProcessing() {
        HttpServletRequest request = ServletUtils.getRequest();
        String lS = request.getParameter(DM_LS), flg = StringUtils.defaultIfBlank(request.getParameter(DM_FLG), "");
        if (StringUtils.isNotEmpty(request.getParameter(DM_FLUSH))) {
            log.info("DM.flush.member_code:{}", userMapper.executeForDM("adam_member_code"));

            log.info("DM.flush.AdamMemberCodeVo:{}", mongoTemplate.remove(Query.query(Criteria.where("_id").exists(true)), AdamMemberCodeVo.class.getSimpleName()).getDeletedCount());
        }

        String sqlCount = "select count(1) from vip_card_codes where buy_order_id <> use_order_id or status=0";
        String field = "vip_card_code,`type`+1,vip_card_id,vip_card_price_id,card_number,`status`,created_at,updated_at,buy_order_id,buy_uid,buy_time,use_order_id,use_uid,use_time";
//      1-vip_card_code,2-`type`+1,3-card_number,4-`status`,5-created_at,6-updated_at,
//      7-buy_order_id,8-buy_uid,9-buy_time,10-use_order_id,11-use_uid,12-use_time
        String sql = sqlCount.replace("count(1)", field);
        sql += " limit ?,?";

        statement = connection.prepareStatement(sqlCount);
        row = (ResultSetImpl) statement.executeQuery();
        row.first();
        int ct = row.getInt(1), pSize = 1000, num = 0, tl = 0;
        log.info("DM.execute.counts:{} ----------------------------> start", ct);

        while (ct > 0) {
            statement = connection.prepareStatement(sql);
            int ls = (num == 0 && StringUtils.isNotEmpty(lS)) ? Integer.parseInt(lS) : pSize * num;
            statement.setInt(1, ls);
            statement.setInt(2, pSize);
            row = (ResultSetImpl) statement.executeQuery();
            log.info("DM.execute.limit {},{} - begin", ls, pSize);

            List<AdamMemberCode> memberCodeList = new ArrayList<>();
            List<AdamMemberCodeVo> vos = new ArrayList<>();
            while (row.next()) {
//                String buyUid = row.getString(8);
//                String useUid = row.getString(11);
//                if (!reUidList.contains(buyUid) && reUidList.contains(useUid)) {
                    AdamMemberCode memberCode = new AdamMemberCode();
                    memberCode.setCode(row.getString(1));
                    memberCode.setType(row.getInt(2));
                    memberCode.setMemberId(MEMBER_ID);
                    memberCode.setMemberPriceId(MEMBER_ID);
                    memberCode.setMemberNo(row.getString(3));
                    memberCode.setState(row.getInt(4));
                    memberCode.setCreatedAt(row.getLocalDateTime(5));
                    memberCode.setUpdatedAt(row.getLocalDateTime(6));
                    memberCode.setBuyOrderNo(mMap.get(row.getString(7)));
                    memberCode.setBuyUid(row.getString(8));
                    memberCode.setBuyAt(row.getLocalDateTime(9));
                    memberCode.setUseOrderNo(mMap.get(row.getString(10)));
                    memberCode.setUseUid(row.getString(11));
                    memberCode.setUseAt(row.getLocalDateTime(12));

                    memberCodeList.add(memberCode);
                    vos.add(AdamMemberCodeVo.getNew().copy(memberCode));
//                }
            }
            log.info("DM.execute.limit {},{} - handle.counts:{}", ls, pSize, memberCodeList.size());
            if (!CollectionUtils.isEmpty(memberCodeList)) {
                tl += memberCodeList.size();
                mongoTemplate.insert(vos, AdamMemberCodeVo.class.getSimpleName());
                log.info("DM.execute.limit.result:{}", adamMemberCodeService.saveBatch(memberCodeList));
            }

            num++;
            ct -= pSize;
        }
        log.info("DM.execute.counts:{} ~ {} ----------------------------> end", num * pSize, tl);
    }
}
