package com.liquidnet.service.consumer.dragon.service.processor;

import lombok.extern.slf4j.Slf4j;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.stream.StreamListener;
import org.springframework.stereotype.Component;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: ConsumerRefundProcessor
 * @Package com.liquidnet.service.consumer.dragon.service.processor
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/7/8 10:59
 */
@Slf4j
@Component
public class ConsumerRefundProcessor implements StreamListener<String, MapRecord<String, String, String>> {

    @Override
    public void onMessage(MapRecord<String, String, String> message) {
        log.info("接受到来自redis REFUND 的消息");
        System.out.println("message id "+message.getId());
        System.out.println("stream "+message.getStream());
        System.out.println("body "+message.getValue());
    }
}
