package com.liquidnet.client.admin.common.enums;

import java.util.*;

/**
 * <p>
 * banner展示位置
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-06-08 12:21 下午
 */
public enum BannersDisplayLocation {

    DISPLAY_LOCATION1("首页", 1),
    DISPLAY_LOCATION4("演出", 4),
    DISPLAY_LOCATION3("周边", 3),
    DISPLAY_LOCATION5("积分商城", 5),
    DISPLAY_LOCATION6("YOUNG BLOOD", 6),
    DISPLAY_LOCATION8("视频", 8),
    DISPLAY_LOCATION9("正在下单", 9),
    ;
    private String name;
    private int index;

    BannersDisplayLocation(String name, int index) {
        this.name = name;
        this.index = index;
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    private static List<Object> resultTypeListR = null;

    static {
        ArrayList<Object> resultTypeList = new ArrayList<>();
        for (BannersDisplayLocation resultType : BannersDisplayLocation.values()) {
            Map<String, Object> mapTemp = new HashMap<>();
            mapTemp.put("id", resultType.index);
            mapTemp.put("name", resultType.name);
            resultTypeList.add(mapTemp);
        }
        resultTypeListR = Collections.unmodifiableList(resultTypeList);
    }

    public static List<Object> getResultType() {
        return resultTypeListR;
    }
}
