package com.liquidnet.client.admin.web.controller.zhengzai.candy;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.pagehelper.PageHelper;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.PageDomain;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.common.core.page.TableSupport;
import com.liquidnet.client.admin.common.utils.StringUtils;
import com.liquidnet.client.admin.common.utils.sql.SqlUtil;
import com.liquidnet.client.admin.zhengzai.candy.service.ICandyCouponAdminService;
import com.liquidnet.client.admin.zhengzai.candy.service.ICandyCouponRuleAdminService;
import com.liquidnet.service.candy.dto.admin.CandyCouponListParam;
import com.liquidnet.service.candy.dto.admin.CandyCouponTemplateDto;
import com.liquidnet.service.candy.entity.CandyCoupon;
import com.liquidnet.service.candy.entity.CandyCouponRule;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;
import java.util.regex.Pattern;

@Api(tags = "我的券包")
@Controller
@RequestMapping("candy/coupon")
public class CandyCouponAdminController extends BaseController {

    @Autowired
    ICandyCouponAdminService candyCouponAdminService;
    @Autowired
    ICandyCouponRuleAdminService candyCouponRuleAdminService;

    @ApiOperation(value = "券列表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = false, dataType = "Integer", name = "busiType", value = "业务类别[0-全场｜1-演出｜2-商品｜3-优先购]"),
            @ApiImplicitParam(type = "form", required = false, dataType = "Integer", name = "couType", value = "券类型[1-代金券｜2-满减券｜3-兑换券｜4-折扣券|101-优先券]"),
            @ApiImplicitParam(type = "form", required = false, dataType = "String", name = "bindType", value = "领取方式[0-用户输入兑换｜1-发放至用户｜2-积分商品｜3-发放需领取｜4-会员专属],多种方式则以,分隔入参"),
            @ApiImplicitParam(type = "form", required = false, dataType = "String", name = "keyword", value = "搜索关键字[支持检索标题title、描述notice、适用描述busiName]"),
    })
    @PostMapping("list")
    @ResponseBody
    public TableDataInfo list(CandyCouponListParam listParam) {
        String bindType = listParam.getBindType();
        if (StringUtils.isNotEmpty(bindType) && !Pattern.matches("^[\\d,]*$", bindType)) {
            listParam.setBindType(null);
        }

        PageDomain pageDomain = TableSupport.buildPageRequest();
        Integer pageNum = pageDomain.getPageNum();
        Integer pageSize = pageDomain.getPageSize();
        String orderBy = SqlUtil.escapeOrderBySql(pageDomain.getOrderBy());
        if (com.liquidnet.client.admin.common.utils.StringUtils.isNotNull(pageNum) && com.liquidnet.client.admin.common.utils.StringUtils.isNotNull(pageSize)) {
        } else {
            pageNum = 1;
            pageSize = 10;
        }
        if (StringUtils.isEmpty(orderBy)) {
            PageHelper.startPage(pageNum, pageSize, "cc.created_at desc");
        } else {
            PageHelper.startPage(pageNum, pageSize, orderBy);
        }
        return getDataTable(candyCouponAdminService.listForCouponFilterDto(listParam));
    }

    @ApiOperation(value = "券详情")
    @GetMapping("info")
    @ResponseBody
    public AjaxResult info(String couponId) {
        CandyCouponTemplateDto couponTemplateDto = CandyCouponTemplateDto.getNew();

        LambdaQueryWrapper<CandyCoupon> couponLambdaQueryWrapper = Wrappers.lambdaQuery();
        couponLambdaQueryWrapper.eq(CandyCoupon::getCouponId, couponId);
        couponLambdaQueryWrapper.eq(CandyCoupon::getState, 1);
        CandyCoupon coupon = candyCouponAdminService.getOne(couponLambdaQueryWrapper);

        LambdaUpdateWrapper<CandyCouponRule> couponRuleLambdaUpdateWrapper = Wrappers.lambdaUpdate(CandyCouponRule.class);
        couponRuleLambdaUpdateWrapper.eq(CandyCouponRule::getCouponId, couponId);
        couponRuleLambdaUpdateWrapper.eq(CandyCouponRule::getState, 1);
        List<CandyCouponRule> couponRuleList = candyCouponRuleAdminService.list(couponRuleLambdaUpdateWrapper);

        couponTemplateDto.setUseRules(couponRuleList);
        return AjaxResult.success(couponTemplateDto.copy(coupon));
    }
}
