package com.liquidnet.client.admin.zhengzai.goblin.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.zhengzai.goblin.service.IGoblinFrontSeckillService;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.goblin.constant.GoblinRedisConst;
import com.liquidnet.service.goblin.entity.GoblinFrontSeckill;
import com.liquidnet.service.goblin.mapper.GoblinFrontSeckillMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 秒杀表 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-29
 */
@Service
public class GoblinFrontSeckillServiceImpl extends ServiceImpl<GoblinFrontSeckillMapper, GoblinFrontSeckill> implements IGoblinFrontSeckillService {
    @Autowired
    GoblinFrontSeckillMapper goblinFrontSeckillMapper;

    public boolean create(GoblinFrontSeckill goblinFrontSeckill){
        goblinFrontSeckill.setCreateTime(LocalDateTime.now());
        //设置bannerid
        goblinFrontSeckill.setSeckilId(GoblinRedisConst.FRONT_BANNER+ IDGenerator.nextTimeId());
        //增加 banner
        goblinFrontSeckillMapper.insert(goblinFrontSeckill);
        return true;
    }
    /***
     * @author zhangfuxin
     * @Description: 修改
     * @date 2021/12/27 下午4:03
     */
    public boolean update(GoblinFrontSeckill goblinFrontSeckill){
        goblinFrontSeckill.setUpdateTime(LocalDateTime.now());
        //数据库修改
        goblinFrontSeckillMapper.updateById(goblinFrontSeckill);
        return true;
    }
    public GoblinFrontSeckill getOne(Long id){
        return  goblinFrontSeckillMapper.selectById(id);
    }

    public boolean delte(Long id){
        GoblinFrontSeckill goblinFrontSeckill=goblinFrontSeckillMapper.selectById(id);
        goblinFrontSeckill.setDelTag(1);
        this.update(goblinFrontSeckill);
        return true;
    }
    /**
     * @author zhangfuxin
     * @Description:分页
     * @date 2021/12/27 下午5:19
     */
    public PageInfo<GoblinFrontSeckill> page(int pageSize, int pageNumber, GoblinFrontSeckill goblinFrontSeckill) {
        PageInfo<GoblinFrontSeckill> pageInfoTmp = null;
        try {
            PageHelper.startPage(pageNumber, pageSize);
            LambdaQueryWrapper<GoblinFrontSeckill> queryWrapper = Wrappers.lambdaQuery(GoblinFrontSeckill.class);
            queryWrapper.orderByDesc(GoblinFrontSeckill::getCreateTime);
            List<GoblinFrontSeckill> list=goblinFrontSeckillMapper.selectList(queryWrapper);
            pageInfoTmp = new PageInfo(list);
        } catch (Exception e) {
            return new PageInfo();
        }
        return pageInfoTmp;
    }

}
