package com.liquidnet.service.platform.controller.adam;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.liquidnet.common.exception.LiquidnetServiceException;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.platform.service.impl.adam.sync.processor.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.time.LocalDateTime;
import java.time.temporal.ChronoField;
import java.util.regex.Pattern;

@ApiSupport(order = 90061)
@Api(tags = "@SYNC")
@Slf4j
@Validated
@RestController
@RequestMapping("adam/sync")
public class PlatformAdamSyncController {
    @Autowired
    SyncUserInformationProcessor syncUserInformationProcessor;
    @Autowired
    SyncThirdPartyProcessor syncThirdPartyProcessor;
    @Autowired
    SyncRealNameProcessor syncRealNameProcessor;
    @Autowired
    SyncUserMemberProcessor syncUserMemberProcessor;
    @Autowired
    SyncMemberOrderProcessor syncMemberOrderProcessor;
    @Autowired
    SyncAddressesProcessor syncAddressesProcessor;
    @Autowired
    SyncEntersProcessor syncEntersProcessor;
    @Autowired
    SyncMemberRelatedProcessor syncMemberRelatedProcessor;
    @Autowired
    SyncRdsModProcessor syncRdsModProcessor;

    @ModelAttribute
    public void accessExecuting(HttpServletRequest request) {
        String alis = request.getHeader("alis");
        LocalDateTime now = LocalDateTime.now();
        int hour = now.get(ChronoField.HOUR_OF_DAY), minute = now.getMinute(), dom = now.get(ChronoField.DAY_OF_MONTH);;
        String lns = "^(" + (dom % 10) + hour % (minute / 10 + 1) + "[A-Z]{2})" + minute / 10 + "[0-9]{1}$";
        log.info("lns:{},alis:{}", lns, alis);
        if (StringUtils.isEmpty(alis) || !Pattern.matches(lns, alis)) {
            throw new LiquidnetServiceException("44444", "非法操作");
        }
        log.info("uri:[{}],Parameter:{}", request.getRequestURI(), request.getParameterMap());
    }

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "T - MTR")
    @GetMapping(value = {"mr/{vn}"})
    public ResponseDto<Object> fromMysqlToRedisHandler(@PathVariable String vn, @RequestParam int stp) {
        switch (vn) {
            case "user":
                syncUserInformationProcessor.dataProcessing(stp);
                break;
            case "tpa":
                syncThirdPartyProcessor.dataProcessing(stp);
                break;
            case "real":
                syncRealNameProcessor.dataProcessing(stp);
                break;
            case "umember":
                syncUserMemberProcessor.dataProcessing(stp);
                break;
            case "morder":
                syncMemberOrderProcessor.dataProcessing(stp);
                break;
            case "address":
                syncAddressesProcessor.dataProcessing(stp);
                break;
            case "enters":
                syncEntersProcessor.dataProcessing(stp);
                break;
            case "mrelated":
                syncMemberRelatedProcessor.dataProcessing(stp);
                break;
            case "rds":
                syncRdsModProcessor.dataProcessing(stp);
                break;
            default:
                return ResponseDto.failure(vn);
        }
        return ResponseDto.success(vn);
    }
}
