package com.liquidnet.service.platform.service.impl.adam.sync.processor;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.pagehelper.PageHelper;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.adam.dto.vo.AdamRealInfoVo;
import com.liquidnet.service.adam.dto.vo.AdamThirdPartInfoVo;
import com.liquidnet.service.adam.entity.AdamRealName;
import com.liquidnet.service.adam.entity.AdamThirdParty;
import com.liquidnet.service.adam.mapper.AdamRealNameMapper;
import com.liquidnet.service.platform.service.impl.adam.sync.SyncDataProcessorService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Slf4j
@Service
public class SyncRealNameProcessor extends SyncDataProcessorService {
    @Autowired
    AdamRealNameMapper realNameMapper;

    @Override
    public void dataProcessing(int stp) {
        LambdaQueryWrapper<AdamRealName> lambdaQueryWrapper =
                Wrappers.lambdaQuery(AdamRealName.class).eq(AdamRealName::getState, 1)
                .orderByDesc(AdamRealName::getMid);
        Integer totalCount = realNameMapper.selectCount(lambdaQueryWrapper);
        int totalRows = null == totalCount ? 0 : totalCount, nth = 0, offset = 5000, pct = 0;
        log.info("Sync.processing.begin:{}/{}, {} ~ {}", totalCount, offset, nth, pct);



        while (totalRows > 0) {
            int rows = nth * offset;
            log.info("Sync.processing.limit {},{} - {} begin", rows, offset, nth);


            PageHelper.startPage(nth + 1, offset);
            List<AdamRealName> dtos = realNameMapper.selectList(lambdaQueryWrapper);
            if (!CollectionUtils.isEmpty(dtos)) {
                int size = dtos.size();
                for (int i = 0; i < size; i++) {
                    AdamRealName dto = dtos.get(i);

                    AdamRealInfoVo vo = AdamRealInfoVo.getNew().copy(dto);
                    //log.info("vo:{}", JsonUtils.toJson(vo));

                    dmRdmService.setRealInfoVoByUid(dto.getUid(), vo);
                    dmRdmService.setCertification(1, dto.getIdCard(), dto.getName());

                    pct++;
                }
            }



            log.info("Sync.processing.limit {},{} - {} handle.counts:{}", rows, offset, nth, pct);
            nth++;
            totalRows -= offset;
        }



        log.info("Sync.processing.end:{} / {},{} ~ {}", totalCount, nth, offset, pct);
    }
}
