package com.liquidnet.service.platform.service.impl.adam.sync.processor;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.pagehelper.PageHelper;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.adam.dto.vo.AdamRealInfoVo;
import com.liquidnet.service.adam.dto.vo.AdamUserMemberVo;
import com.liquidnet.service.adam.entity.AdamRealName;
import com.liquidnet.service.adam.entity.AdamUserMember;
import com.liquidnet.service.adam.mapper.AdamUserMemberMapper;
import com.liquidnet.service.platform.service.impl.adam.sync.SyncDataProcessorService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Slf4j
@Service
public class SyncUserMemberProcessor extends SyncDataProcessorService {
    @Autowired
    AdamUserMemberMapper userMemberMapper;

    @Override
    public void dataProcessing(int stp) {
        LambdaQueryWrapper<AdamUserMember> lambdaQueryWrapper =
                Wrappers.lambdaQuery(AdamUserMember.class).orderByDesc(AdamUserMember::getMid);
        Integer totalCount = userMemberMapper.selectCount(lambdaQueryWrapper);
        int totalRows = null == totalCount ? 0 : totalCount, nth = 0, offset = 5000, pct = 0;
        log.info("Sync.processing.begin:{}/{}, {} ~ {}", totalCount, offset, nth, pct);



        while (totalRows > 0) {
            int rows = nth * offset;
            log.info("Sync.processing.limit {},{} - {} begin", rows, offset, nth);


            PageHelper.startPage(nth + 1, offset);
            List<AdamUserMember> dtos = userMemberMapper.selectList(lambdaQueryWrapper);
            if (!CollectionUtils.isEmpty(dtos)) {
                int size = dtos.size();
                for (int i = 0; i < size; i++) {
                    AdamUserMember dto = dtos.get(i);

                    AdamUserMemberVo vo = AdamUserMemberVo.getNew().copy(dto);
                    //log.info("vo:{}", JsonUtils.toJson(vo));

                    dmRdmService.setUserMemberVoByUid(dto.getUid(), vo);

                    pct++;
                }
            }



            log.info("Sync.processing.limit {},{} - {} handle.counts:{}", rows, offset, nth, pct);
            nth++;
            totalRows -= offset;
        }



        log.info("Sync.processing.end:{} / {},{} ~ {}", totalCount, nth, offset, pct);
    }
}
