package com.liquidnet.service.feign.sweet.task;

import com.liquidnet.service.base.ResponseDto;
import feign.hystrix.FallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Component
@FeignClient(name = "liquidnet-service-sweet",
        contextId = "FeignSweetWechatClient", path = "",
        url = "${liquidnet.service.sweet.url}",
        fallback = FallbackFactory.Default.class)
public interface FeignSweetWechatClient {

    @GetMapping("sweet/wechatTemplate/send")
    ResponseDto send();

    @GetMapping("sweet/appletSubMsg/send")
    ResponseDto sendSubMsg(@RequestParam("type") Integer type);

}
