package com.liquidnet.service.goblin.controller;

import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.utils.poi.ExcelUtil;
import com.liquidnet.service.goblin.dto.vo.OrderMallOrderVo;
import com.liquidnet.service.goblin.service.IGoblinImportService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

@Controller
@RequestMapping("/import")
public class GoblinImportController {

    private String prefix = "zhengzai/kylin/performances/orderImport";

    @Autowired
    IGoblinImportService iGoblinImportService;

    /**
     * 导入对订单发货
     */
    @PostMapping("/OrderExpress")
    @ResponseBody
    public AjaxResult importOrderExpress(MultipartFile file) throws Exception {
        ExcelUtil<OrderMallOrderVo> util = new ExcelUtil(OrderMallOrderVo.class);
        List<OrderMallOrderVo> MallOrdertVoList = util.importExcel(file.getInputStream());
        String message = iGoblinImportService.importExpress(MallOrdertVoList);
        return AjaxResult.success(message);
    }
}
