package com.liquidnet.client.admin.zhengzai.adam.dto;

import com.liquidnet.client.admin.common.annotation.Excel;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.adam.entity.AdamMemberCode;
import lombok.Data;

import java.io.Serializable;

@Data
public class AdamMemberCodeExcelDto implements Serializable, Cloneable {
    private static final long serialVersionUID = -6775626480969657499L;
    @Excel(name = "会员码")
    private String code;
    @Excel(name = "状态")
    private Integer state;
    @Excel(name = "用户UID")
    private String useUid;
    @Excel(name = "生效时间", width = 30)
    private String effectAt;
    @Excel(name = "过期时间", width = 30)
    private String expireAt;
    @Excel(name = "批次号")
    private String memberId;
    
    private static final AdamMemberCodeExcelDto obj = new AdamMemberCodeExcelDto();

    public static AdamMemberCodeExcelDto getNew() {
        try {
            return (AdamMemberCodeExcelDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new AdamMemberCodeExcelDto();
        }
    }

    public AdamMemberCodeExcelDto copy(AdamMemberCode source) {
        if (null == source) return this;
        this.setCode(source.getCode());
        this.setState(source.getState());
        this.setUseUid(source.getUseUid());
        this.setEffectAt(DateUtil.Formatter.yyyyMMddHHmmss.format(source.getEffectAt()));
        this.setExpireAt(DateUtil.Formatter.yyyyMMddHHmmss.format(source.getExpireAt()));
        this.setMemberId(source.getMemberId());
        return this;
    }
}
