package com.liquidnet.common.third.xuper.dto;

import lombok.Data;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 获取访问BOS临时STS凭证
 * @class: Xuper001GetStokenRespDto
 * @Package com.liquidnet.common.third.xuper.dto
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/4/18 15:10
 */
@Data
public class XuperUploadFileRespDto {
    public String link;
    public GetStokenResp resp;
    public RequestRes res;

    @Data
    public static class GetStokenResp {
        public long requestId;
        public int errNo;
        public String errMsg;
        public AccessInfo accessInfo;
    }

    @Data
    public static class AccessInfo {
        public String bucket;
        public String endPoint;
        public String objectPath;
        public String accessKeyId;
        public String secreteAccessKey;
        public String sessionToken;
        public String createTime;
        public String expiration;
    }

    @Data
    public static class RequestRes {
        public int httpCode;
        public String reqUrl;
        public String traceId;
        public String body;
    }

    private static final XuperUploadFileRespDto obj = new XuperUploadFileRespDto();
    public static XuperUploadFileRespDto getNew() {
        try {
            return (XuperUploadFileRespDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new XuperUploadFileRespDto();
        }
    }
}
