package com.liquidnet.service.goblin.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

@Data
@EqualsAndHashCode
public class GoblinMixUpdateParam implements Serializable, Cloneable {
    @ApiModelProperty(position = 0, value = "活动id")
    private String mixId;
    @ApiModelProperty(position = 4, value = "展示位置[1-商城|2-数字藏品]")
    private Integer showPosition;
    @ApiModelProperty(position = 17, value = "限购数量[0-无限]")
    private Integer limit;
    @ApiModelProperty(position = 18, value = "白名单类型[0-会员|1-指定用户|2-全部用户]")
    private Integer whiteType;
    @ApiModelProperty(position = 19, value = "白名单xls地址")
    private String whiteUrl;
    @ApiModelProperty(position = 20, value = "xls名称")
    private String xlsName;

    private static final GoblinMixUpdateParam obj = new GoblinMixUpdateParam();

    public static GoblinMixUpdateParam getNew() {
        try {
            return (GoblinMixUpdateParam) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinMixUpdateParam();
        }
    }
}
