package com.liquidnet.client.admin.web.controller.zhengzai.slime;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.client.admin.common.annotation.Log;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.common.enums.BusinessType;
import com.liquidnet.client.admin.zhengzai.slime.service.ISlimeSponsorsAdminService;
import com.liquidnet.service.slime.dto.param.admin.SlimeSponsorEditParam;
import com.liquidnet.service.slime.dto.param.admin.SlimeSponsorListParam;
import com.liquidnet.service.slime.dto.vo.SlimeSponsorsVo;
import com.liquidnet.service.slime.entity.SlimeSponsors;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

@Api(tags = "主办管理")
@Controller
@RequestMapping("slime/sponsor")
public class SlimeSponsorsController extends BaseController {

    private final String prefix = "zhengzai/kylin/sponsor";

    @Autowired
    ISlimeSponsorsAdminService slimeSponsorsAdminService;


    @GetMapping()
    public String list() {
        return prefix + "/list";
    }


    @Log(title = "主办列表", businessType = BusinessType.LIST)
    @RequiresPermissions("slime:sponsor")
    @PostMapping("/list")
    @ResponseBody
    public TableDataInfo list(SlimeSponsorListParam param) {
        startPage();
        return getDataTable(slimeSponsorsAdminService.list(
                Wrappers.lambdaQuery(SlimeSponsors.class)
                        .eq(param.getSponsorId().length() > 0, SlimeSponsors::getSponsorId, param.getSponsorId())
                        .eq(param.getIsOnline() >= 0, SlimeSponsors::getIsOnline, param.getIsOnline())
                        .select(
                                SlimeSponsors::getSponsorId, SlimeSponsors::getIsOnline, SlimeSponsors::getUid,
                                SlimeSponsors::getName, SlimeSponsors::getLogo,
                                SlimeSponsors::getCreatedAt
                        )
        ));
    }

    @Log(title = "主办详情", businessType = BusinessType.DETAIL)
    @RequiresPermissions("slime:sponsor")
    @GetMapping(value = "/details/{sponsorId}")
    public String detail(@PathVariable("sponsorId") String sponsorId, ModelMap mmap) {

        LambdaQueryWrapper<SlimeSponsors> sponsorsLambdaQueryWrapper = Wrappers.lambdaQuery(SlimeSponsors.class);
        sponsorsLambdaQueryWrapper.eq(SlimeSponsors::getSponsorId, sponsorId);
        SlimeSponsors sponsors = slimeSponsorsAdminService.getOne(sponsorsLambdaQueryWrapper);

        SlimeSponsorsVo sponsorsVo = SlimeSponsorsVo.getNew();
        sponsorsVo.copy(sponsors);

        mmap.put("sponsorInfo", sponsorsVo);

        return prefix + "/detail";
    }

    @ApiOperation(value = "主办编辑")
    @Log(title = "主办编辑", businessType = BusinessType.UPDATE)
    @RequiresPermissions("slime:sponsor")
    @PostMapping("edit")
    @ResponseBody
    public AjaxResult edit(@RequestBody @Validated SlimeSponsorEditParam parameter) {
        return toAjax(slimeSponsorsAdminService.sponsorEdit(parameter));
    }
}
