package com.liquidnet.service.kylin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;


/**
 * 用户领取兑换码表
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class KylinRewardUser implements Serializable, Cloneable{

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 用户ID
     */
    private String uid;

    /**
     * 所属福袋ID
     */
    private String luckyBagId;

    /**
     * 订单ID（kylin_order_tickets）
     */
    private String orderId;

    /**
     * 订单详情ID（kylin_order_ticket_entities）
     */
    private String orderTicketEntitiesId;

    /**
     * 兑换码
     */
    private String code;

    /**
     * 状态 0不可用 1可用
     */
    private Integer state;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 修改时间
     */
    private LocalDateTime updatedAt;

    /**
     * 保留字段
     */
    private String comment;

}
