package com.liquidnet.service.goblin.controller;


import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.vo.GoblinGoodsAnticipateHelpVo;
import com.liquidnet.service.goblin.service.IGoblinGoodsAnticipateService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 预约表 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2022-04-07
 */
@Slf4j
@RestController
@Api(tags = "预约相关")
@RequestMapping("/anticipate")
public class GoblinGoodsAnticipateController {

    @Autowired
    IGoblinGoodsAnticipateService goblinGoodsAnticipateService;

    @ApiOperation("用户预约 （只能预约不能取消）")
    @PostMapping("/userAbout")
    public ResponseDto<Object> userAbout(@RequestParam(name = "skuId", required = true) String skuId) {
        return goblinGoodsAnticipateService.userAbout(skuId);
    }

    @ApiOperation("根据skuId和uid查询")
    @GetMapping("/selectAnticipateBySkuIdAndUid")
    public ResponseDto<Boolean> selectAnticipate(@RequestParam(name = "skuId") String skuId) {
        return goblinGoodsAnticipateService.selectAnticipate(skuId);
    }

    @ApiOperation("用户分享,根据sku发起助力")
    @PostMapping("/share")
    public ResponseDto<Object> share(@RequestParam(name = "skuId", required = true) String skuId,
                                     @RequestParam(name = "url", required = false) String url) {
        return goblinGoodsAnticipateService.share(skuId, url);
    }

    @ApiOperation("用户为他人助力")
    @PatchMapping("help")
    public ResponseDto<Object> help(@RequestParam(name = "sid", required = true) String sid) {
        return goblinGoodsAnticipateService.help(sid);
    }

    @ApiOperation("获取助力头像")
    @PatchMapping("getHelpAvatar")
    public ResponseDto<Object> getHelpAvatar(@RequestParam(name = "sid", required = true) String sid) {
        return goblinGoodsAnticipateService.getHelpAvatar(sid);
    }

}
