package com.liquidnet.service.stone.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;

import com.liquidnet.service.stone.dto.StoneScoreListDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 积分日志表
 * </p>
 *
 * @author liquidnet
 * @since 2021-10-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class StoneScoreLogs implements Serializable ,Cloneable{

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * id
     */
    private String logsId;

    /**
     * 用户id
     */
    private String uid;

    /**
     * 积分
     */
    private BigDecimal score;

    /**
     * 积分动态明细
     */
    private String content;

    /**
     * 变更原因
     */
    private String reason;

    /**
     * 过期时间
     */
    private LocalDateTime overdueAt;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;

    private String comment;

    private static final StoneScoreLogs obj = new StoneScoreLogs();
    public static StoneScoreLogs getNew() {
        try {
            return (StoneScoreLogs) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new StoneScoreLogs();
    }
}
