package com.liquidnet.client.admin.zhengzai.smile.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * @author TT
 */
@Data
public class SmileUserParam {

    @ApiModelProperty(value = "用户id", example = "")
    private String uid;

    @ApiModelProperty(value = "手机号", example = "")
    private String phone;

    @ApiModelProperty(value = "代理类型（1：总代，2：普代）", example = "")
    private Integer type;

    @ApiModelProperty(value = "姓名")
    private String name;

    @ApiModelProperty(value = "性别 1：男，2女")
    private Integer sex;

    @ApiModelProperty(value = "身份（1:在校学生（默认），2已毕业）")
    private Integer identity;

    @ApiModelProperty(value = "学校id")
    private String schoolId;

    @ApiModelProperty(value = "用户状态0：正常，1：黑名单", example = "")
    private Integer state;

    @ApiModelProperty(value = "页数", example = "0")
    @NotNull(message = "页数不能为空")
    private Integer pageSize;

    @ApiModelProperty(value = "数量", example = "20")
    @NotNull(message = "数量不能为空")
    private Integer pageNum;

    @ApiModelProperty(value = "排序字段", hidden = true)
    private String orderItem;

    @ApiModelProperty(value = "排序方式", hidden = true)
    private String orderSc;
}
