package com.liquidnet.service.erp.param;

import com.liquidnet.service.erp.constant.ErpEnum;
import lombok.Data;

import java.math.BigDecimal;
import java.util.HashMap;

@Data
public class LogisticsListParam implements Cloneable {

    // 回写的记录id，见logistics_sync_query中rec_id
    private int rec_id;
    // 回写状态: 0成功 1失败
    private int status;
    // 相关描述信息,可在erp的物流同步界面看到
    private BigDecimal message;

    private static final LogisticsListParam obj = new LogisticsListParam();

    public static LogisticsListParam getNew() {
        try {
            return (LogisticsListParam) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new LogisticsListParam();
        }
    }

    public HashMap<String, Object> test(int recId, int status) {
        HashMap<String, Object> map = new HashMap<>();
        map.put("rec_id", recId);
        map.put("status", status);
        map.put("message", "test");
        return map;
    }
}
