package com.liquidnet.client.admin.zhengzai.goblin.utils;

import com.liquidnet.service.goblin.dto.vo.GoblinMarketingZhengzaiRelationVo;
import com.liquidnet.service.goblin.dto.vo.GoblinSelfMarketingVo;
import com.liquidnet.service.goblin.entity.GoblinMarketingZhengzaiRelation;
import com.liquidnet.service.goblin.entity.GoblinSelfMarketing;
import com.mongodb.BasicDBObject;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

@Component
public class GoblinMongoUtils {

    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    private MongoConverter mongoConverter;

    public GoblinSelfMarketingVo insertSelfMarket(GoblinSelfMarketingVo data) {
        return mongoTemplate.insert(data, GoblinSelfMarketingVo.class.getSimpleName());
    }

    public UpdateResult updateSelfMarket(String selfMarketId, GoblinSelfMarketingVo data) {
        BasicDBObject object = GoblinObjectUtils.cloneBasicDBObject().append("$set", mongoConverter.convertToMongoType(data));
        return mongoTemplate.getCollection(GoblinSelfMarketing.class.getSimpleName()).updateOne(
                Query.query(Criteria.where("selfMarketId").is(selfMarketId)).getQueryObject(),
                object);
    }

    public DeleteResult delSelfMarket(String selfMarketId) {
        return mongoTemplate.remove(Query.query(Criteria.where("selfMarketId").is(selfMarketId)), GoblinSelfMarketingVo.class.getSimpleName());
    }

    public GoblinMarketingZhengzaiRelationVo insertZhengzaiRelation(GoblinMarketingZhengzaiRelationVo data) {
        return mongoTemplate.insert(data, GoblinMarketingZhengzaiRelationVo.class.getSimpleName());
    }

    public UpdateResult updateZhengzaiRelation(String selfMarketId, String storeId,GoblinMarketingZhengzaiRelationVo data) {
        BasicDBObject object = GoblinObjectUtils.cloneBasicDBObject().append("$set", mongoConverter.convertToMongoType(data));
        return mongoTemplate.getCollection(GoblinMarketingZhengzaiRelationVo.class.getSimpleName()).updateOne(
                Query.query(Criteria.where("selfMarketId").is(selfMarketId).and("storeId").is(storeId)).getQueryObject(),
                object);
    }

    public DeleteResult delZhengzaiRelation(String marketId,String storeId) {
        return mongoTemplate.remove(Query.query(Criteria.where("storeId").is(storeId).and("selfMarketId").is(marketId)), GoblinMarketingZhengzaiRelationVo.class.getSimpleName());
    }

}
