package com.liquidnet.service.goblin.controller.manage;

import com.github.pagehelper.PageInfo;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.vo.GoblinOrderLogVo;
import com.liquidnet.service.goblin.service.manage.IGoblinStoreMoneyService;
import io.swagger.annotations.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.util.HashMap;


@ApiSupport(order = 149102)
@Api(tags = "店铺资金模块")
@Slf4j
@Validated
@RestController
@RequestMapping("store/money")
public class GoblinStoreMoneyController {
    @Autowired
    IGoblinStoreMoneyService goblinStoreMoneyService;

    @GetMapping("money")
    @ApiOperation("商品资金总收入")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = false, dataType = "String", name = "spuId", value = "spuId"),
    })
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<HashMap<String,String>> money(@RequestParam(value = "spuId", required = false) String spuId) {
        return goblinStoreMoneyService.money(spuId);
    }

    @GetMapping("spu/list")
    @ApiOperation("商品资金列表")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = false, dataType = "String", name = "spuName", value = "商品名称"),
            @ApiImplicitParam(type = "form", required = false, dataType = "String", name = "st", value = "起始时间"),
            @ApiImplicitParam(type = "form", required = false, dataType = "String", name = "et", value = "终止时间"),
            @ApiImplicitParam(type = "form", required = true, dataType = "Integer", name = "page", value = "页数"),
    })
    public ResponseDto<PageInfo<GoblinOrderLogVo>> getSpuList(@RequestParam(value = "spuName", required = false) String spuName,
                                                              @RequestParam(value = "st", required = false) String st,
                                                              @RequestParam(value = "et", required = false) String et,
                                                              @RequestParam(value = "page") Integer page) {
        return goblinStoreMoneyService.getSpuList(spuName, st, et, page);
    }

    @GetMapping("orderOpera/list")
    @ApiOperation("商品订单操作日志列表")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = false, dataType = "String", name = "spuId", value = "spuId"),
            @ApiImplicitParam(type = "form", required = false, dataType = "String", name = "orderCode", value = "订单号"),
            @ApiImplicitParam(type = "form", required = false, dataType = "Integer", name = "type", value = "交易类型[1-订单交易，2-订单退款，3-正在下单[订单交易]，4-正在下单[订单退款]]"),
            @ApiImplicitParam(type = "form", required = false, dataType = "String", name = "st", value = "起始时间"),
            @ApiImplicitParam(type = "form", required = false, dataType = "String", name = "et", value = "终止时间"),
            @ApiImplicitParam(type = "form", required = true, dataType = "Integer", name = "page", value = "页数"),
            @ApiImplicitParam(type = "form", required = false, dataType = "Integer", name = "type2", value = "[1-收入|2-支出]"),
    })
    public ResponseDto<PageInfo<GoblinOrderLogVo>> getOrderOperaList(@RequestParam(value = "spuId", required = false) String spuId,
                                                                     @RequestParam(value = "orderCode", required = false) String orderCode,
                                                                     @RequestParam(value = "type", required = false) Integer type,
                                                                     @RequestParam(value = "st", required = false) String st,
                                                                     @RequestParam(value = "et", required = false) String et,
                                                                     @RequestParam(value = "page") Integer page) {
        return goblinStoreMoneyService.getOrderOperaList(spuId, orderCode, type, st, et, page);
    }

}
