package com.liquidnet.service.merchant.service.impl;

import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dto.vo.KylinExpressModuleVo;
import com.liquidnet.service.kylin.dto.vo.middle.KylinBuyNoticeVo;
import com.liquidnet.service.kylin.service.partner.IKylinBuyNoticePartnerService;
import com.liquidnet.service.merchant.util.RedisMerchantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 购票须知表 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-18
 */
@Service
public class KylinBuyNoticePartnerServiceImpl implements IKylinBuyNoticePartnerService {

    @Autowired
    RedisMerchantUtils merchantUtils;

    @Override
    public PageInfo<KylinBuyNoticeVo> getBuyNotice() {
        List<KylinBuyNoticeVo> buyNoticeList = merchantUtils.getBuyNotice();
        PageInfo<KylinBuyNoticeVo> pageInfoTmp = new PageInfo(buyNoticeList);
        return pageInfoTmp;
    }

    @Override
    public ResponseDto<List<KylinExpressModuleVo>> getExpressList() {
        return ResponseDto.success(merchantUtils.expressList());
    }


}
