package com.liquidnet.service.kylin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 人流量检测记录表
 * </p>
 *
 * @author jiangxiulong
 * @since 2022-01-10
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class KylinCameraRecord implements Serializable, Cloneable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Integer mid;

    /**
     * camera_record_id
     */
    private String cameraRecordId;

    /**
     * camera_id
     */
    private String cameraId;

    /**
     * 检测到的人数
     */
    private Integer personNum;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;

    private static final KylinCameraRecord obj = new KylinCameraRecord();
    public static KylinCameraRecord getNew() {
        try {
            return (KylinCameraRecord) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new KylinCameraRecord();
        }
    }


}
